/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.service.impl.server;

import cn.gtmap.estateplat.bank.service.server.ExportService;
import cn.gtmap.estateplat.bank.utils.PlatformUtil;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    private static Logger logger = LoggerFactory.getLogger(ExportServiceImpl.class);
    @Resource(name="FileCenterNodeServiceImpl")
    private NodeService fileCenterNodeServiceImpl;

    public boolean sendFileCenter(String path, String proid, String nodeName, String folderName) {
        boolean bol = false;
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)proid)) {
            Integer project_fileId = PlatformUtil.getProjectFileId((String)proid);
            Integer nodeId = PlatformUtil.getNodeId((Integer)project_fileId, (String)folderName);
            bol = PlatformUtil.uploadFileFromPath((String)path, (Integer)nodeId, (String)nodeName);
        }
        return bol;
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public Integer createFileFolderByclmc(Integer parentId, String folderNodeName) {
        Node tempNode = null;
        if (StringUtils.isNotBlank((CharSequence)folderNodeName)) {
            try {
                tempNode = this.fileCenterNodeServiceImpl.getNode(parentId, folderNodeName, true);
            }
            catch (NodeNotFoundException e) {
                logger.error("\u9644\u4ef6\u4e0a\u4f20\u83b7\u53d6tempNode\u5f02\u5e38\uff01", (Throwable)e);
            }
            if (null != tempNode) {
                return tempNode.getId();
            }
            return -1;
        }
        return -1;
    }
}

