/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.service.impl.log;

import cn.gtmap.estateplat.bank.aop.PublicLogAspect;
import cn.gtmap.estateplat.bank.entity.QueryXtLog;
import cn.gtmap.estateplat.bank.service.log.LogService;
import cn.gtmap.estateplat.bank.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import cn.gtmap.estateplat.utils.DateUtils;
import cn.gtmap.estateplat.utils.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
implements LogService {
    private static final Logger logger = LoggerFactory.getLogger(PublicLogAspect.class);
    @Autowired
    @Qualifier(value="entityMapper")
    private EntityMapper entityMapper;
    @Autowired
    @Qualifier(value="serverEntityMapper")
    private EntityMapper serverEntityMapper;

    public <T> void saveLog(T obj, Class<T> clazz) {
        block10: {
            try {
                if (clazz.equals(QueryXtLog.class)) {
                    QueryXtLog queryLog = (QueryXtLog)obj;
                    if (StringUtils.isBlank((CharSequence)queryLog.getLogid())) {
                        queryLog.setLogid(UUID.hex32());
                    }
                    if (StringUtils.equals((CharSequence)Constants.server_enable, (CharSequence)"true")) {
                        this.serverEntityMapper.saveOrUpdate((Object)queryLog, (Object)queryLog.getLogid());
                    } else {
                        this.entityMapper.saveOrUpdate((Object)queryLog, (Object)queryLog.getLogid());
                    }
                    break block10;
                }
                if (clazz.equals(BdcXtLog.class)) {
                    BdcXtLog bdcXtLog = (BdcXtLog)obj;
                    if (StringUtils.isBlank((CharSequence)bdcXtLog.getLogid())) {
                        bdcXtLog.setLogid(UUID.hex32());
                    }
                    if (StringUtils.equals((CharSequence)Constants.server_enable, (CharSequence)"true")) {
                        this.serverEntityMapper.saveOrUpdate((Object)bdcXtLog, (Object)bdcXtLog.getLogid());
                    } else {
                        this.entityMapper.saveOrUpdate((Object)bdcXtLog, (Object)bdcXtLog.getLogid());
                    }
                    break block10;
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6b64\u65e5\u5fd7\u7c7b\u578b");
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error("errorMsg:", (Throwable)e);
            }
        }
    }

    public Object queryInfo(Map parms) {
        Example example = new Example(QueryXtLog.class);
        Example.Criteria criteria = example.createCriteria();
        if (MapUtils.isNotEmpty((Map)parms) && parms.get("beginTime") != null && parms.get("endTime") != null) {
            String dwdm;
            Date beginTime = (Date)parms.get("beginTime");
            Date endTime = (Date)parms.get("endTime");
            endTime = new Date(DateUtils.addDays((java.util.Date)endTime, (int)1).getTime());
            String czlx = parms.get("czlx") == null ? "" : parms.get("czlx").toString();
            String string = dwdm = parms.get("dwdm") == null ? "" : parms.get("dwdm").toString();
            if (StringUtils.isNotBlank((CharSequence)czlx)) {
                if (StringUtils.isNotBlank((CharSequence)dwdm)) {
                    criteria.andGreaterThanOrEqualTo("czrq", (Object)beginTime).andLessThanOrEqualTo("czrq", (Object)endTime).andEqualTo("controller", (Object)czlx).andEqualTo("dwdm", (Object)dwdm);
                } else {
                    criteria.andGreaterThanOrEqualTo("czrq", (Object)beginTime).andLessThanOrEqualTo("czrq", (Object)endTime).andEqualTo("controller", (Object)czlx);
                }
            } else if (StringUtils.isNotBlank((CharSequence)dwdm)) {
                criteria.andGreaterThanOrEqualTo("czrq", (Object)beginTime).andLessThanOrEqualTo("czrq", (Object)endTime).andEqualTo("dwdm", (Object)dwdm);
            } else {
                criteria.andGreaterThanOrEqualTo("czrq", (Object)beginTime).andLessThanOrEqualTo("czrq", (Object)endTime);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)parms.get("username")))) {
            criteria.andIn("username", (List)parms.get("username"));
        }
        example.setOrderByClause("czrq desc");
        List lists = StringUtils.equals((CharSequence)Constants.server_enable, (CharSequence)"true") ? this.serverEntityMapper.selectByExample(example) : this.entityMapper.selectByExample(example);
        return this.dealLogResult(lists);
    }

    private <T extends BdcXtLog> List<T> dealLogResult(List<T> arg) {
        String systemVersion = Constants.plVersion;
        if (CollectionUtils.isEmpty(arg)) {
            return null;
        }
        boolean sfCN = false;
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"bank.yangzhou.queryxtCN")) && "true".equals(AppConfig.getProperty((String)"bank.yangzhou.queryxtCN"))) {
            sfCN = true;
        }
        if (!("bozhou".equals(systemVersion) || "jurong".equals(systemVersion) || sfCN)) {
            for (BdcXtLog log : arg) {
                String parmjson = log.getParmjson();
                JSONObject jsonObject = JSON.parseObject((String)parmjson);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    StringBuilder tempParam = new StringBuilder();
                    String key = (String)entry.getKey();
                    List val = (List)entry.getValue();
                    tempParam.append("\u67e5\u8be2\u63cf\u8ff0\uff1a " + key + "\uff1b");
                    if (CollectionUtils.isNotEmpty((Collection)val)) {
                        for (int i = 0; i < val.size(); ++i) {
                            tempParam.append((String)((Map)val.get(i)).get("parameterName"));
                            tempParam.append(" : ");
                            tempParam.append((String)((Map)val.get(i)).get("parameterValue"));
                            tempParam.append(" ; ");
                        }
                    }
                    log.setParmjson(tempParam.toString());
                }
            }
        }
        return arg;
    }
}

