/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.aop;

import cn.gtmap.estateplat.bank.entity.QueryXtLog;
import cn.gtmap.estateplat.bank.service.log.LogService;
import cn.gtmap.estateplat.bank.utils.Constants;
import cn.gtmap.estateplat.log.AuditLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Aspect
@Component
public class PublicLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(PublicLogAspect.class);
    @Autowired
    private LogService publicLogServiceImpl;
    @Autowired
    private SysUserService sysUserService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String ANONYMOUS_USER_ID = "-999";
    private static final String ANONYMOUS_USER_NAME = "\u533f\u540d\u7528\u6237";
    private static final String PLVERSION = Constants.plVersion;

    @Pointcut(value="@annotation(cn.gtmap.estateplat.log.AuditLog)")
    public void doLog() {
        Object publicKey = null;
    }

    @Before(value="doLog()")
    public void doBefore(JoinPoint joinPoint) {
    }

    @AfterReturning(pointcut="doLog()", returning="returnValue")
    public void afterReturning(JoinPoint joinPoint, Object returnValue) {
        Method method = this.getMethod(joinPoint);
        AuditLog publicMethodLog = method.getAnnotation(AuditLog.class);
        String resultJSON = "\u5220\u9664\u64cd\u4f5c!";
        String content = "";
        if (returnValue != null) {
            if (returnValue instanceof PageImpl) {
                content = this.getAuditContent(method, joinPoint, publicMethodLog, returnValue);
            } else {
                resultJSON = returnValue.toString();
                content = this.getAuditContent(method, joinPoint, publicMethodLog, (Object)resultJSON);
            }
        }
        content = this.getAuditContent(method, joinPoint, publicMethodLog, (Object)resultJSON);
        this.generateLog(publicMethodLog.name(), content, null);
    }

    private void generateLog(String name, String content, String userId) {
        QueryXtLog queryXtLog = new QueryXtLog();
        queryXtLog.setLogid(UUIDGenerator.generate());
        queryXtLog.setCzrq(Calendar.getInstance().getTime());
        if (StringUtils.isNotBlank((CharSequence)SessionUtil.getCurrentUserId())) {
            queryXtLog.setUserid(SessionUtil.getCurrentUserId());
            queryXtLog.setUsername(SessionUtil.getCurrentUser().getUsername());
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            PfUserVo pfUserVo;
            queryXtLog.setUserid(userId);
            if (this.sysUserService != null && (pfUserVo = this.sysUserService.getUserVo(userId)) != null) {
                queryXtLog.setUsername(pfUserVo.getUserName());
            }
        } else {
            queryXtLog.setUserid(ANONYMOUS_USER_ID);
            queryXtLog.setUsername(ANONYMOUS_USER_NAME);
        }
        List pfOrganVoList = this.sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
        if (CollectionUtils.isNotEmpty((Collection)pfOrganVoList)) {
            String dwdms = "";
            for (int i = 0; i < pfOrganVoList.size(); ++i) {
                if (!StringUtils.isNotBlank((CharSequence)((PfOrganVo)pfOrganVoList.get(i)).getRegionCode())) continue;
                dwdms = dwdms + ((PfOrganVo)pfOrganVoList.get(i)).getRegionCode() + ",";
            }
            queryXtLog.setDwdm(dwdms);
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = request.getRemoteAddr();
        queryXtLog.setIp(ip);
        queryXtLog.setController(name);
        queryXtLog.setParmjson(content);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getAuditContent(Method method, JoinPoint joinPoint, AuditLog publicLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = StringUtils.isNotBlank((CharSequence)publicLog.description()) ? publicLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
        contentMap.put(description, this.dealArguments(method, joinPoint));
        return JSON.toJSONString((Object)contentMap);
    }

    private String getAuditContent(Method method, JoinPoint joinPoint, AuditLog publicLog, Object result) {
        String returnStr = "";
        boolean sfCN = false;
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"bank.yangzhou.queryxtCN")) && "true".equals(AppConfig.getProperty((String)"bank.yangzhou.queryxtCN"))) {
            sfCN = true;
        }
        if ("bozhou".equals(PLVERSION) || "jurong".equals(PLVERSION) || sfCN) {
            JSONObject jsonObject;
            JSONArray jsonObject1;
            String params = this.dealArguments1(method, joinPoint).toString();
            int begin = params.indexOf("parameterValue=");
            String jsonStr = params.substring(begin + 15, params.length() - 2);
            if ("queryBdcqz".equals(method.getName()) && (jsonObject1 = JSONArray.parseArray((String)((String)result))) != null && jsonObject1.size() > 0) {
                JSONObject json = JSONObject.parseObject((String)jsonObject1.get(0).toString());
                if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                    JSONObject jsonObject2 = JSONObject.parseObject((String)jsonStr);
                    returnStr = "\u67e5\u8be2\u4ea7\u6743\u8bc1\u4e66\u4fe1\u606f/\u516c\u79ef\u91d1\u67e5\u8be2\u4ea7\u6743\u8bc1\u4e66:\u67e5\u8be2\u6761\u4ef6\uff1a$\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7:" + jsonObject2.get((Object)"bdcqzh") + "$\u6743\u5229\u4eba\u540d\u79f0:" + jsonObject2.get((Object)"qlr") + "$\u5750\u843d:" + jsonObject2.get((Object)"zl") + "$\u67e5\u8be2\u76ee\u7684:" + jsonObject2.get((Object)"cxmd") + "$\u67e5\u8be2\u7ed3\u679c:$\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7:" + json.get((Object)"bdcqzh") + "$\u6743\u5229\u4eba\u540d\u79f0:" + json.get((Object)"QLRMC") + "$\u5750\u843d:" + json.get((Object)"ZL") + "$\u4e0d\u52a8\u4ea7\u5355\u5143\u53f7:" + json.get((Object)"BDCDYH");
                }
            }
            if ("queryZmhByPage".equals(method.getName())) {
                if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                    jsonObject = JSONObject.parseObject((String)jsonStr);
                    returnStr = "\u67e5\u8be2\u94f6\u884c\u62b5\u62bc\u4fe1\u606f:\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7:" + jsonObject.get((Object)"bdcqzh") + "$\u4ed6\u9879\u8bc1\u660e\u53f7:" + jsonObject.get((Object)"bdcqzmh") + "$\u67e5\u8be2\u76ee\u7684:" + jsonObject.get((Object)"cxmd") + "$\u62b5\u62bc\u4eba:" + jsonObject.get((Object)"dyr") + "$\u62b5\u62bc\u4eba\u8bc1\u4ef6\u53f7\u7801:" + jsonObject.get((Object)"dyrzjhm") + "$\u5750\u843d:" + jsonObject.get((Object)"zl");
                }
                JSONObject page = JSONObject.parseObject((String)((String)result));
                Map row = (Map)((List)page.get((Object)"rows")).get(0);
                returnStr = returnStr + "$\u67e5\u8be2\u7ed3\u679c:\u4e0d\u52a8\u4ea7\u767b\u8bb0\u8bc1\u660e\u53f7:" + row.get("BDCDJZMH") + "$\u7b49,\u5171" + page.get((Object)"total") + "$\u6761";
            }
            if (("exportDyaqExcel".equals(method.getName()) || "exportDyaqSelect".equals(method.getName())) && StringUtils.isNotBlank((CharSequence)jsonStr)) {
                jsonStr = jsonStr.substring(1, jsonStr.length() - 1);
                jsonStr = StringEscapeUtils.unescapeJava((String)jsonStr);
                jsonObject = JSONObject.parseObject((String)jsonStr);
                returnStr = "\u5bfc\u51fa\u94f6\u884c\u62b5\u62bc\u4fe1\u606f:\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7:" + jsonObject.get((Object)"bdcqzh") + "$\u4ed6\u9879\u8bc1\u660e\u53f7:" + jsonObject.get((Object)"bdcqzmh") + "$\u67e5\u8be2\u76ee\u7684:" + jsonObject.get((Object)"cxmd") + "$\u62b5\u62bc\u4eba:" + jsonObject.get((Object)"dyr") + "$\u62b5\u62bc\u4eba\u8bc1\u4ef6\u53f7\u7801:" + jsonObject.get((Object)"dyrzjhm") + "$\u5750\u843d:" + jsonObject.get((Object)"zl");
            }
            if ("deleteAllDataById".equals(method.getName()) && StringUtils.isNotBlank((CharSequence)jsonStr)) {
                returnStr = "\u5220\u9664\u94f6\u884c\u62b5\u62bc\u7533\u8bf7:\u94f6\u884c\u7533\u8bf7\u7f16\u53f7:" + jsonStr.substring(jsonStr.indexOf("bh"));
            }
            if ("exportDySqExcel".equals(method.getName()) && StringUtils.isNotBlank((CharSequence)jsonStr)) {
                jsonStr = jsonStr.substring(1, jsonStr.length() - 1);
                jsonStr = StringEscapeUtils.unescapeJava((String)jsonStr);
                jsonObject = JSONObject.parseObject((String)jsonStr);
                returnStr = "\u5bfc\u51fa\u94f6\u884c\u7533\u8bf7\u53f0\u8d26\u4fe1\u606f:\u7f16\u53f7:" + jsonObject.get((Object)"bh") + "$\u5ba1\u6838\u72b6\u6001:" + jsonObject.get((Object)"shzt") + "$\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7:" + jsonObject.get((Object)"bdcqzh") + "$\u62b5\u62bc\u5f00\u59cb\u65f6\u95f4:" + jsonObject.get((Object)"zwlxksqx") + "$\u62b5\u62bc\u7ed3\u675f\u65f6\u95f4:" + jsonObject.get((Object)"zwlxjsqx");
            }
        } else {
            HashMap contentMap = Maps.newHashMap();
            String description = StringUtils.isNotBlank((CharSequence)publicLog.description()) ? publicLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
            contentMap.put(description, this.dealArguments(method, joinPoint));
            if (null != result) {
                ArrayList arguments = Lists.newArrayList();
                HashMap item = Maps.newHashMap();
                item.put("parameterType", "JSONObject");
                item.put("parameterValue", JSONObject.toJSONString((Object)result));
                item.put("parameterName", "result");
                arguments.add(item);
                contentMap.put("\u8fd4\u56de\u7ed3\u679c", arguments);
            }
            returnStr = JSON.toJSONString((Object)contentMap);
        }
        return returnStr;
    }

    private Object dealArguments(Method method, JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        String[] paraNameArr = new LocalVariableTableParameterNameDiscoverer().getParameterNames(method);
        ArrayList arguments = Lists.newArrayList();
        for (int i = 0; i < args.length; ++i) {
            HashMap item = Maps.newHashMap();
            if (args[i] instanceof Model || args[i] instanceof Pageable || args[i] instanceof RedirectAttributes || args[i] instanceof HttpServletResponse || args[i] instanceof HttpServletRequest) continue;
            Object arg = args[i];
            item.put("parameterType", arg.getClass().getSimpleName());
            item.put("parameterValue", JSONObject.toJSONString((Object)arg));
            item.put("parameterName", paraNameArr[i]);
            arguments.add(item);
        }
        return arguments;
    }

    private Object dealArguments1(Method method, JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        String[] paraNameArr = new LocalVariableTableParameterNameDiscoverer().getParameterNames(method);
        ArrayList arguments = Lists.newArrayList();
        for (int i = 0; i < args.length; ++i) {
            HashMap item = Maps.newHashMap();
            if (args[i] instanceof Model || args[i] instanceof Pageable || args[i] instanceof RedirectAttributes || args[i] instanceof HttpServletResponse || args[i] instanceof HttpServletRequest) continue;
            Object arg = args[i];
            item.put("parameterValue", JSONObject.toJSONString((Object)arg));
            arguments.add(item);
        }
        return arguments;
    }

    private Method getMethod(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Class[] argTypes = new Class[joinPoint.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = null;
        try {
            method = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), argTypes);
        }
        catch (NoSuchMethodException e) {
            logger.error("errorMsg:", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("errorMsg:", (Throwable)e);
        }
        return method;
    }

    public static String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        if (!"wuhu".equals(Constants.plVersion)) {
            try {
                String cmd = "nbtstat -A " + ip;
                File file = new File("C:\\Windows\\System32\\nbtstat.exe");
                cmd = file.exists() ? "cmd /c c:\\Windows\\System32\\nbtstat.exe -A " + ip : "c:\\Windows\\sysnative\\nbtstat.exe -A " + ip;
                Process process = Runtime.getRuntime().exec(cmd);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.indexOf("MAC") <= 1) continue;
                    macAddress = line.substring(str.indexOf("MAC") + 15, line.length());
                    macAddress = macAddress.trim();
                    break;
                }
                process.waitFor();
            }
            catch (Exception e) {
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        return macAddress;
    }

    public static String getComputerName(String ip) {
        String computerName = "";
        try {
            String cmd = "nbtstat -A " + ip;
            File file = new File("C:\\Windows\\System32\\nbtstat.exe");
            cmd = file.exists() ? "cmd /c c:\\Windows\\System32\\nbtstat.exe -A " + ip : "c:\\Windows\\sysnative\\nbtstat.exe -A " + ip;
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (line == null || (line = line.trim().replaceAll("\\s{1,}", "")).indexOf("<") <= 1) continue;
                computerName = line.substring(0, line.indexOf("<"));
                break;
            }
            process.waitFor();
        }
        catch (Exception e) {
            logger.error("errorMsg:", (Throwable)e);
        }
        return computerName;
    }

    static /* synthetic */ LogService access$000(PublicLogAspect x0) {
        return x0.publicLogServiceImpl;
    }
}

