/*
 * Decompiled with CFR 0.152.
 */
package epoint.frame.encrypt.sm4;

import epoint.frame.encrypt.security.FormartUtil;
import epoint.frame.encrypt.security.SecurityUtil;
import epoint.frame.encrypt.security.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SM4Util {
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 0;
    private static final int NUM = 32;
    private static final String INIT_KEY = "epoint@sm4.safety";
    private static final String INIT_NEW_KEY = "E4B1B468A5A596C0ABE3B7C2889353FC";
    private static final String INIT_IV = "epoint@vector.safety";
    private static HashMap<String, String> keys = new HashMap();
    private static Boolean isOldModel = true;

    public static String encrypt(String sourceData) {
        return SM4Util.encrypt(sourceData, null, null, null);
    }

    public static String encrypt(String sourceData, Boolean isOld) {
        return SM4Util.encrypt(sourceData, null, null, isOld);
    }

    public static String encrypt(String sourceData, String prik, String iv) {
        return SM4Util.encrypt(sourceData, prik, iv, null);
    }

    public static String encrypt(String sourceData, String prik, String iv, Boolean isOld) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] hexBytes = SM4Util.dealSourceData(sourceData);
        byte[] key = SM4Util.generateKey(prik, isOld);
        byte[] mIV = SM4Util.generateIv(iv, isOld);
        byte[] paddingbuf = SM4Util.padding(hexBytes, 1);
        byte[] buf = SM4Util.dealBytes(key, mIV, paddingbuf, true);
        return FormartUtil.byteToHex(buf);
    }

    public static String decrypt(String cipher) {
        return SM4Util.decrypt(cipher, null, null, null);
    }

    public static String decrypt(String cipher, Boolean isOld) {
        return SM4Util.decrypt(cipher, null, null, isOld);
    }

    public static String decrypt(String cipher, String prik, String iv) {
        return SM4Util.decrypt(cipher, prik, iv, null);
    }

    public static String decrypt(String cipher, String prik, String iv, Boolean isOld) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] cipherBytes = FormartUtil.hexToByte(cipher);
        byte[] key = SM4Util.generateKey(prik, isOld);
        byte[] mIV = SM4Util.generateIv(iv, isOld);
        byte[] buf = SM4Util.dealBytes(key, mIV, cipherBytes, false);
        cipherBytes = SM4Util.padding(buf, 0);
        String hex = FormartUtil.byteToHex(cipherBytes);
        cipherBytes = isOld != false ? Hex.decode((String)hex) : FormartUtil.hexToByte(hex);
        byte[] base64bytes = Base64.decode((byte[])cipherBytes);
        try {
            return new String(base64bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
    }

    public static String encryptEcb(String sourceData) {
        return SM4Util.encryptEcb(sourceData, null, null, true);
    }

    public static String encryptEcb(String sourceData, boolean isPadding) {
        return SM4Util.encryptEcb(sourceData, null, null, isPadding);
    }

    public static String encryptEcb(String sourceData, Boolean isOld) {
        return SM4Util.encryptEcb(sourceData, null, isOld, true);
    }

    public static String encryptEcb(String sourceData, Boolean isOld, boolean isPadding) {
        return SM4Util.encryptEcb(sourceData, null, isOld, isPadding);
    }

    public static String encryptEcb(String sourceData, String prik) {
        return SM4Util.encryptEcb(sourceData, prik, null, true);
    }

    public static String encryptEcb(String sourceData, String prik, boolean isPadding) {
        return SM4Util.encrypt(sourceData, prik, null, isPadding);
    }

    public static String encryptEcb(String sourceData, String prik, Boolean isOld, boolean isPadding) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] plainBytes = null;
        try {
            plainBytes = sourceData.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
        plainBytes = Base64.encode((byte[])plainBytes);
        byte[] hexBytes = Hex.decode((String)FormartUtil.byteToHex(plainBytes));
        byte[] key = SM4Util.generateKey(prik, isOld);
        if (isPadding) {
            hexBytes = SM4Util.padding(hexBytes, 1);
        }
        byte[] buf = SM4Util.dealBytes(key, null, hexBytes, true);
        return FormartUtil.byteToHex(buf);
    }

    public static String decryptEcb(String cipher) {
        return SM4Util.decryptEcb(cipher, null, null, true);
    }

    public static String decryptEcb(String cipher, boolean isPadding) {
        return SM4Util.decryptEcb(cipher, null, null, isPadding);
    }

    public static String decryptEcb(String cipher, Boolean isOld) {
        return SM4Util.decryptEcb(cipher, null, isOld, true);
    }

    public static String decryptEcb(String cipher, Boolean isOld, boolean isPadding) {
        return SM4Util.decryptEcb(cipher, null, isOld, isPadding);
    }

    public static String decryptEcb(String cipher, String prik) {
        return SM4Util.decryptEcb(cipher, prik, null, true);
    }

    public static String decryptEcb(String cipher, String prik, boolean isPadding) {
        return SM4Util.decryptEcb(cipher, prik, null, isPadding);
    }

    public static String decryptEcb(String cipher, String prik, Boolean isOld, boolean isPadding) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] cipherBytes = FormartUtil.hexToByte(cipher);
        byte[] key = SM4Util.generateKey(prik, isOld);
        byte[] buf = SM4Util.dealBytes(key, null, cipherBytes, false);
        byte[] resultBytes = null;
        if (isPadding) {
            resultBytes = SM4Util.padding(buf, 0);
        } else {
            int index = 0;
            int i = buf.length - 1;
            while (i >= 0) {
                byte b = buf[i];
                if (b != 0) break;
                index = i--;
            }
            int needadd = index % 8;
            if (needadd != 0) {
                index += needadd;
            }
            resultBytes = new byte[index];
            System.arraycopy(buf, 0, resultBytes, 0, index);
        }
        String hex = FormartUtil.byteToHex(resultBytes);
        resultBytes = Hex.decode((String)hex);
        byte[] base64bytes = Base64.decode((byte[])resultBytes);
        try {
            return new String(base64bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
    }

    public static String encryptSM4(String plainText, String prik, String iv) {
        return SM4Util.encryptSM4(plainText, prik, iv, null);
    }

    public static String encryptSM4(String plainText, String prik, String iv, Boolean isOld) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] plainBytes = null;
        try {
            plainBytes = plainText.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
        plainBytes = Base64.encode((byte[])plainBytes);
        StringBuilder hexString = new StringBuilder(FormartUtil.byteToHex(plainBytes));
        while (hexString.length() % 16 != 0) {
            hexString.append("0");
        }
        byte[] hexBytes = Hex.decode((String)hexString.toString());
        byte[] key = SM4Util.generateKey(prik, isOld);
        int length = hexBytes.length;
        byte[] buf = new byte[length < 16 ? 16 : length];
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        int i = 0;
        while (i < buf.length) {
            buf[i] = i < hexBytes.length ? hexBytes[i] : (byte)0;
            ++i;
        }
        byte[] mIV = SM4Util.generateIv(iv, isOld);
        int bufLength = buf.length;
        int i2 = 0;
        while (i2 < bufLength) {
            buf[i2] = (byte)(buf[i2] ^ mIV[i2 % 16]);
            ++i2;
        }
        i2 = 0;
        while (i2 != 32) {
            engine.processBlock(buf, 0, buf, 0);
            ++i2;
        }
        return FormartUtil.byteToHex(buf);
    }

    public static String decryptSM4(String data, String prik, String iv) {
        return SM4Util.decryptSM4(data, prik, iv, null);
    }

    public static String decryptSM4(String data, String prik, String iv, Boolean isOld) {
        if (isOld == null) {
            isOld = isOldModel;
        }
        byte[] cipherBytes = FormartUtil.hexToByte(data);
        byte[] key = SM4Util.generateKey(prik, isOld);
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int i = 0;
        while (i != 32) {
            engine.processBlock(cipherBytes, 0, cipherBytes, 0);
            ++i;
        }
        byte[] mIV = SM4Util.generateIv(iv, isOld);
        int cipherLength = cipherBytes.length;
        int i2 = 0;
        while (i2 < cipherLength) {
            cipherBytes[i2] = (byte)(cipherBytes[i2] ^ mIV[i2 % 16]);
            ++i2;
        }
        String hexStringDecrypt = FormartUtil.byteToHex(cipherBytes);
        while (hexStringDecrypt.endsWith("0")) {
            hexStringDecrypt = hexStringDecrypt.substring(0, hexStringDecrypt.length() - 1);
        }
        StringBuilder sb = new StringBuilder(hexStringDecrypt);
        while (sb.toString().length() % 8 != 0) {
            sb.append("0");
        }
        cipherBytes = isOld != false ? Hex.decode((String)sb.toString()) : FormartUtil.hexToByte(sb.toString());
        byte[] base64bytes = Base64.decode((byte[])cipherBytes);
        try {
            return new String(base64bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
    }

    public static byte[] generateKey(String key, boolean isOld) {
        String tempprik;
        if (isOld) {
            if (StringUtil.isBlank(key)) {
                key = INIT_KEY;
            }
            key = StringUtil.toUpperCase(SM4Util.encryptionMD5(key.getBytes()));
        } else if (StringUtil.isBlank(key)) {
            key = INIT_NEW_KEY;
        }
        String string = tempprik = isOld ? key : String.valueOf(key) + "_new";
        if (!keys.containsKey(tempprik)) {
            String newKey = isOld ? key : SecurityUtil.getDealedHexString(key, 128, "SM4");
            keys.put(tempprik, newKey);
        }
        String hexString = keys.get(tempprik);
        if (isOld) {
            return Hex.decode((String)hexString);
        }
        return FormartUtil.hexToByte(hexString);
    }

    public static byte[] generateIv(String iv, boolean isOld) {
        byte[] mIV = StringUtil.isBlank(iv) ? Hex.decode((String)SM4Util.encryptionMD5(INIT_IV.getBytes())) : (isOld ? Hex.decode((String)SM4Util.encryptionMD5(iv.getBytes())) : FormartUtil.hexToByte(iv));
        return mIV;
    }

    private static byte[] dealSourceData(String sourceData) {
        byte[] plainBytes = null;
        try {
            plainBytes = sourceData.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf-8\u7f16\u7801\u683c\u5f0f", e);
        }
        plainBytes = Base64.encode((byte[])plainBytes);
        return Hex.decode((String)FormartUtil.byteToHex(plainBytes));
    }

    private static String encryptionMD5(byte[] byteStr) {
        StringBuilder md5StrBuff = new StringBuilder();
        try {
            byte[] byteArray;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(byteStr);
            byte[] byArray = byteArray = messageDigest.digest();
            int n = byteArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte aByteArray = byArray[n2];
                if (Integer.toHexString(0xFF & aByteArray).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & aByteArray));
                } else {
                    md5StrBuff.append(Integer.toHexString(0xFF & aByteArray));
                }
                ++n2;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return md5StrBuff.toString();
    }

    private static byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }
        byte[] ret = null;
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            int i = 0;
            while (i < p) {
                ret[input.length + i] = (byte)p;
                ++i;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] dealBytes(byte[] key, byte[] iv, byte[] data, boolean model) {
        result = null;
        engine = new SM4Engine();
        engine.init(model, (CipherParameters)new KeyParameter(key));
        length = data.length;
        bins = new ByteArrayInputStream(data);
        bous = new ByteArrayOutputStream();
        try {
            try {
                block19: {
                    block18: {
                        if (!model) break block18;
                        if (iv != null) ** GOTO lbl37
                        while (length > 0) {
                            in = new byte[16];
                            out = new byte[16];
                            bins.read(in);
                            engine.processBlock(in, 0, out, 0);
                            bous.write(out);
                            length -= 16;
                        }
                        break block19;
lbl-1000:
                        // 1 sources

                        {
                            in = new byte[16];
                            out = new byte[16];
                            out1 = new byte[16];
                            bins.read(in);
                            i = 0;
                            while (i < 16) {
                                out[i] = (byte)(in[i] ^ iv[i]);
                                ++i;
                            }
                            engine.processBlock(out, 0, out1, 0);
                            System.arraycopy(out1, 0, iv, 0, 16);
                            bous.write(out1);
                            length -= 16;
lbl37:
                            // 2 sources

                            ** while (length > 0)
                        }
lbl38:
                        // 1 sources

                        break block19;
                    }
                    if (iv != null) ** GOTO lbl67
                    while (length > 0) {
                        in = new byte[16];
                        out = new byte[16];
                        bins.read(in);
                        engine.processBlock(in, 0, out, 0);
                        bous.write(out);
                        length -= 16;
                    }
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        in = new byte[16];
                        out = new byte[16];
                        out1 = new byte[16];
                        bins.read(in);
                        engine.processBlock(in, 0, out, 0);
                        i = 0;
                        while (i < 16) {
                            out1[i] = (byte)(out[i] ^ iv[i]);
                            ++i;
                        }
                        System.arraycopy(in, 0, iv, 0, 16);
                        bous.write(out1);
                        length -= 16;
lbl67:
                        // 2 sources

                        ** while (length > 0)
                    }
                }
                result = bous.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    bous.close();
                    bins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                bous.close();
                bins.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

