/*
 * Decompiled with CFR 0.152.
 */
package epoint.frame.encrypt.sm2;

import epoint.frame.encrypt.security.FormartUtil;
import epoint.frame.encrypt.security.SecurityUtil;
import epoint.frame.encrypt.security.StringUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.test.TestRandomBigInteger;

public class SM2Util {
    private SM2Engine sm2Engine;
    private static ECCurve curve;
    private static ECDomainParameters domainParams;
    private String pubk;
    private String prik;
    private boolean oldModel = true;
    private static final String PUB = "_pub";
    private static HashMap<String, ECKeyParameters> keys;
    private static HashMap<String, String> pubkeys;

    static {
        keys = new HashMap();
        pubkeys = new HashMap();
        BigInteger SM2_ECC_P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        BigInteger SM2_ECC_A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        BigInteger SM2_ECC_B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        BigInteger SM2_ECC_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        curve = new ECCurve.Fp(SM2_ECC_P, SM2_ECC_A, SM2_ECC_B);
        ECPoint g = curve.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        domainParams = new ECDomainParameters(curve, g, SM2_ECC_N);
    }

    public SM2Util() {
        this(null, null, null);
    }

    public SM2Util(Boolean isOld) {
        this(null, null, isOld);
    }

    public SM2Util(String pubk, String prik) {
        this(pubk, prik, null);
    }

    public SM2Util(String pubk, String prik, Boolean isOld) {
        String tempprik;
        if (isOld != null) {
            this.oldModel = isOld;
        }
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        if (StringUtil.isBlank(prik) && StringUtil.isBlank(pubk)) {
            prik = "646AF6FC57D918E01C90DBF67C2BE0445078CEADDD4B692313D6DA9D0F811D99";
        }
        String string = tempprik = this.oldModel ? prik : String.valueOf(prik) + "_new";
        if (StringUtil.isNotBlank(prik)) {
            if (!keys.containsKey(tempprik) && !pubkeys.containsKey(tempprik)) {
                String newPrik = prik;
                if (!this.oldModel) {
                    newPrik = SecurityUtil.getDealedHexString(prik, 256, "SM2");
                }
                ECKeyGenerationParameters aKeyGenParams = new ECKeyGenerationParameters(domainParams, (SecureRandom)new TestRandomBigInteger(newPrik, 16));
                keyPairGenerator.init((KeyGenerationParameters)aKeyGenParams);
                AsymmetricCipherKeyPair aKp = keyPairGenerator.generateKeyPair();
                ECPublicKeyParameters aPub = (ECPublicKeyParameters)aKp.getPublic();
                ECPrivateKeyParameters aPriv = (ECPrivateKeyParameters)aKp.getPrivate();
                String genPub = FormartUtil.byteToHex(aPub.getQ().getEncoded(false));
                pubkeys.put(tempprik, genPub);
                pubkeys.put(genPub, prik);
                keys.put(genPub, (ECKeyParameters)aPub);
                keys.put(tempprik, (ECKeyParameters)aPriv);
                keys.put(String.valueOf(tempprik) + PUB, (ECKeyParameters)aPub);
            }
            this.prik = prik;
            this.pubk = pubkeys.get(tempprik);
        } else if (StringUtil.isNotBlank(pubk)) {
            if (!keys.containsKey(pubk)) {
                byte[] publicKey = FormartUtil.hexToByte(pubk);
                ECPublicKeyParameters aPub = new ECPublicKeyParameters(curve.decodePoint(publicKey), domainParams);
                keys.put(pubk, (ECKeyParameters)aPub);
            }
            this.pubk = pubk;
            this.prik = pubkeys.get(pubk);
        }
        this.sm2Engine = new SM2Engine();
    }

    public String encrypt(String text) throws Exception {
        byte[] m = Base64.getEncoder().encode(text.getBytes("utf-8"));
        String key = this.pubk;
        if (StringUtil.isBlank(key)) {
            String tempprik = this.oldModel ? this.prik : String.valueOf(this.prik) + "_new";
            key = String.valueOf(tempprik) + PUB;
        }
        this.sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keys.get(key), new SecureRandom()));
        byte[] enc = this.sm2Engine.processBlock(m, 0, m.length);
        return FormartUtil.byteToHex(enc);
    }

    public String decrypt(String enc) throws Exception {
        String tempprik = this.oldModel ? this.prik : String.valueOf(this.prik) + "_new";
        this.sm2Engine.init(false, (CipherParameters)keys.get(tempprik));
        byte[] eec = FormartUtil.hexToByte(enc);
        byte[] dec = this.sm2Engine.processBlock(eec, 0, eec.length);
        byte[] eee = Base64.getDecoder().decode(dec);
        return new String(eee, "utf-8");
    }

    public String getPubk() {
        return this.pubk;
    }

    public String getPrik() {
        return this.prik;
    }

    public Boolean isOldModel() {
        return this.oldModel;
    }

    public static String generatorSM2Key(String aPrik) {
        SM2Util util = new SM2Util(null, aPrik);
        return String.valueOf(util.getPubk()) + "_" + util.getPrik();
    }
}

