/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     UserService.java
 * Modifier: yangxin
 * Modified: 2014-06-12 21:35
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.model.identity.User;
import cn.gtmap.egovplat.security.ex.PasswordException;
import cn.gtmap.egovplat.security.ex.UserLockedException;
import cn.gtmap.egovplat.security.ex.UserNotFoundException;

import java.util.List;

/**
 * 用户管理服务.
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-12
 */
public interface UserService {

    /**
     * 根据id获取用户
     *
     * @param id 主键
     * @return 用户
     * @throws UserNotFoundException 用户未找到
     */
    User getUser(String id) throws UserNotFoundException;

    /**
     * 根据用户名获取用户
     *
     * @param name 用户名
     * @return 用户
     */
    User getUserByName(String name);

    /**
     * 校验登录密码
     *
     * @param name     用户名
     * @param password 密码
     * @throws UserNotFoundException 用户未找到
     * @throws cn.gtmap.egovplat.security.ex.UserLockedException   用户已被锁定
     * @throws PasswordException     密码错误
     */
    User validatePassword(String name, String password) throws UserNotFoundException, UserLockedException, PasswordException;

    /**
     * 更新密码
     *
     * @param id       用户id
     * @param password 密码
     */
    void updatePassword(String id, String password);

    /**
     * 保存用户
     *
     * @param user 用户
     * @return 用户
     */
    User saveUser(User user);

    /**
     * 删除单个用户
     * @param id  用户id
     */
    void deleteUser(String id);

    /**
     * 查找用户
     * @param name
     * @param request
     * @return
     */
    public Page<User> findUsersByName(String name, Pageable request);

    /**
     * 查找用户
     * @param userName
     * @return
     */
    public List<User> getUserList(String userName);


}
