package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.model.manage.Subsystem;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Subsystem management子系统管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/3
 */
public interface SubsystemService {

    /**
     * 根据id获取子系统
     * @param id 主键
     * @return
     * @throws EntityNotFoundException
     */
    Subsystem getSubsystem(String id) throws EntityNotFoundException;

    /**
     * 根据ids获取子系统
     * @param ids
     * @return
     */
    Map<String, Subsystem> mgetSubsystems(Collection<String> ids);

    /**
     * 根据name获取子系统
     * @param name 子系统名称
     * @return
     * @throws EntityNotFoundException
     */
    Subsystem getSubsystemByName(String name) throws EntityNotFoundException;


    /**
     * 根据条件、分页参数查找子系统
     * @param predicate 谓词条件
     * @param request 分页参数
     * @return
     */
    Page<Subsystem> findSubsystem(Predicate predicate, Pageable request);

    /**
     * 保存子系统
     * @param subsystem 子系统对象
     * @return
     */
    Subsystem saveSubsystem(Subsystem subsystem);

    /**
     * 根据ids批量删除子系统
     * @param ids 主键集合
     */
    void removeSubsystem(Collection<String> ids);

    /**
     * 根据子系统名称查找子系统
     * @param subsystemName 子系统名称
     * @return
     */
    public List<Subsystem> searchSubsystemBySubsystemName(String subsystemName);

    /**
     * 修改子系统
     * @param subsystem 子系统
     * @return
     */
    public Subsystem mergeSubsystem(Subsystem subsystem);

    /**
     * 修改子系统与菜单关联关系，将菜单id与子系统关联
     * @param subsystem 子系统
     * @param menuIds 菜单id
     */
    public void updateSubsystem(Subsystem subsystem, List<String> menuIds);

    /**
     * 插入菜单和子系统关联关系
     * @param subsystem
     * @param menuIds
     */
    public void insertSubsystem(Subsystem subsystem, List<String> menuIds);

    /**
     * 批量修改子系统与菜单关联
     * @param subsystemIds 子系统ids
     * @param menuIds 菜单ids
     */
    public void updateSubsystems(List<String> subsystemIds, List<String> menuIds);

}
