package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.model.manage.Resource;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Resource Management资源管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/3
 */
public interface ResourceService {

    /**
     * 根据id获取资源
     * @param id 主键
     * @return
     * @throws EntityNotFoundException
     */
    Resource getResource(String id) throws EntityNotFoundException;

    /**
     * 根据ids批量获取资源
     * @param ids 主键
     * @return
     */
    Map<String, Resource> mgetResources(Collection<String> ids);

    /**
     * 根据name获取资源
     * @param name 资源名称
     * @return
     * @throws EntityNotFoundException
     */
    Resource getResourceByName(String name) throws EntityNotFoundException;


    /**
     * 根据条件、分页参数查找资源
     * @param predicate 谓词条件
     * @param request 分页参数
     * @return
     */
    Page<Resource> findResource(Predicate predicate, Pageable request);

    /**
     * 保存资源
     * @param resource 资源对象
     * @return
     */
    Resource saveResource(Resource resource);

    /**
     * 根据ids批量删除资源
     * @param ids 主键集合
     */
    void removeResource(Collection<String> ids);

    /**
     * 根据业务名称查找资源
     * @param resourceName 资源名称
     * @return
     */
    public List<Resource> searchResourceByResourceName(String resourceName);

    /**
     * 修改资源
     * @param resource 资源
     * @return
     */
    public Resource mergeResource(Resource resource);
}
