package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.model.bpm.ProcessDefine;

import java.io.InputStream;

/**
 * 流程定义服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/18
 */
public interface ProcessDefineService {

    /**
     * 根据流程定义Id获取流程定义
     * @param id 流程定义Id
     * @return
     */
    public ProcessDefine getProcessDefine(String id);

    /**
     * 根据Bpm流程定义Key获取流程定义
     * @param bpmKey
     * @return
     */
    public ProcessDefine getProcessDefineByBpmKey(String bpmKey);

    /**
     * 逻辑删除流程定义
     * @param id 流程定义Id
     */
    public void deleteProcessDefine(String id);

    /**
     * 获取流程定义分页
     * @param pageable
     * @return
     */
    public Page<ProcessDefine> findProcessDefines(Pageable pageable);

    /**
     * 保存或更新流程定义
     * @param processDefine
     * @return
     */
    public ProcessDefine saveProcessDefine(ProcessDefine processDefine);

    /**
     * 根据工作流定义Id，启动工作流实例
     * @param id 工作流定义Id
     * @param name 工作流实例名称
     */
    public String startProcessInstanceById(String id,String name);

    /**
     * 根据工作流定义Id，获取流程图
     * @param id 流程定义Id
     * @return
     */
    public InputStream getProcessDefineDiagram(String id);

    /**
     * 获取工作定义的BPMN xml文件
     * @param id 流程定义Id
     * @return
     */
    public InputStream getProcessDefineBPMNXml(String id);

    /**
     *  根据资源名，资源流创建工作流定义
     * @param resourceName 资源名
     * @param bpmFileStream 资源流
     * @return 工作流定义对象
     * @throws Exception
     */
    public ProcessDefine createProcessDefine(String resourceName,InputStream bpmFileStream) throws Exception;

    /**
     * 根据工作流定义对象生成工作流定义
     * @param processDefine
     * @return
     */
    public ProcessDefine createProcessDefine(ProcessDefine processDefine);

    /**
     * 获取工作流定义模型的EditorSource
     * @param id 流程定义Id
     * @return
     */
    public byte[] getProcessDefineModelEditorSource(String id);

    /**
     * 更新工作流定义对象
     * @param id 工作流定义Id
     * @param xml 工作流定义xml字节流
     * @param diagram 工作流定义流程图片
     * @return
     */
    public ProcessDefine updateProcessDefine(String id, byte[] xml, byte[] diagram) throws Exception;
}
