package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.model.manage.Menu;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 菜单管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/3
 */
public interface MenuService {
    /**
     * 根据id获取菜单
     * @param id 主键
     * @return
     * @throws EntityNotFoundException
     */
    Menu getMenu(String id) throws EntityNotFoundException;

    /**
     * 根据ids批量获取菜单
     * @param ids 主键
     * @return
     */
    Map<String, Menu> mgetMenus(Collection<String> ids);

    /**
     * 根据name获取菜单
     * @param name 菜单名称
     * @return
     * @throws EntityNotFoundException
     */
    Menu getMenuByName(String name) throws EntityNotFoundException;


    /**
     * 根据条件、分页参数查找菜单
     * @param predicate 谓词条件
     * @param request 分页参数
     * @return
     */
    Page<Menu> findMenu(Predicate predicate, Pageable request);

    /**
     * 保存菜单
     * @param menu 菜单对象
     * @return
     */
    Menu saveMenu(Menu menu);

    /**
     * 根据ids批量删除菜单
     * @param ids 主键集合
     */
    void removeMenu(Collection<String> ids);

    /**
     * 根据业务名称查找菜单
     * @param menuName 菜单名称
     * @return
     */
    public List<Menu> searchMenuByMenuName(String menuName);

    /**
     * 修改菜单
     * @param menu 菜单
     * @return
     */
    public Menu mergeMenu(Menu menu);

    /**
     * 修改菜单（菜单基本信息，菜单关联的资源）
     *
     * @param menu
     * @param resourceId
     */
    public void updateMenu(Menu menu, String resourceId);

}
