package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.model.bpm.Business;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 *  Business Management业务分类管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/3
 */
public interface BusinessService {
    /**
     * 根据id获取业务
     * @param id 主键
     * @return
     * @throws EntityNotFoundException
     */
    Business getBusiness(String id) throws EntityNotFoundException;

    /**
     * 根据ids批量获取业务
     * @param ids 主键
     * @return
     */
    Map<String, Business> mgetBusinesses(Collection<String> ids);

    /**
     * 根据name获取业务
     * @param name 业务名称
     * @return
     * @throws EntityNotFoundException
     */
    Business getBusinessByName(String name) throws EntityNotFoundException;


    /**
     * 根据条件、分页参数查找业务
     * @param predicate 谓词条件
     * @param request 分页参数
     * @return
     */
    Page<Business> findBusiness(Predicate predicate, Pageable request);

    /**
     * 保存业务
     * @param business 业务对象
     * @return
     */
    Business saveBusiness(Business business);

    /**
     * 根据ids批量删除业务
     * @param ids 主键集合
     */
    void removeBusiness(Collection<String> ids);

    /**
     * 根据业务名称查找业务
     * @param businessName 业务名称
     * @return
     */
    public List<Business> searchBusinessByBusinessName(String businessName);

    /**
     * 修改业务
     * @param business 业务
     * @return
     */
    public Business mergeBusiness(Business business);

}
