package cn.gtmap.egovplat.security.web;



import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.Sec;
import cn.gtmap.egovplat.security.SecurityContext;
import cn.gtmap.egovplat.security.SessionProvider;
import cn.gtmap.egovplat.security.ex.NoPermissonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-9-26
 */
public class SecContextFilter extends OncePerRequestFilter {
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;
    protected volatile SessionProvider sessionProvider;
    private String[] excludes;
    private String[] needLogins;
    private String redirectUrl;

    @Autowired
    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    protected void initFilterBean() throws ServletException {
        initSessionProvider();
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        initSessionProvider();
        if (RequestUtils.matchAny(request, urlPathHelper, pathMatcher, excludes)) {
            filterChain.doFilter(request, response);
        } else {
            try {
                SecurityContext.getContext().setSession(sessionProvider.getSession(request, response));
                if (RequestUtils.matchAny(request, urlPathHelper, pathMatcher, needLogins) && Sec.isGuest()) {
                    if (redirectUrl != null) {
                        response.sendRedirect(redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + "url=" + ServletUriComponentsBuilder.fromRequest(request).build().encode());
                    } else {
                        throw new NoPermissonException("Need login");
                    }
                } else {
                    filterChain.doFilter(request, response);
                }
            } finally {
                SecurityContext.clearContext();
            }
        }
    }

    private void initSessionProvider() {
        if (sessionProvider == null) {
            synchronized (this) {
                if (sessionProvider == null) {
                    WebApplicationContext was = getWebApplicationContext(getServletContext());
                    if (was != null) {
                        was.getAutowireCapableBeanFactory().autowireBean(this);
                    }
                }
            }
        }
    }

    private WebApplicationContext getWebApplicationContext(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext(servletContext);
    }
}
