package cn.gtmap.egovplat.security.impl;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-21
 */
public class TokenSsoSessionProvider implements SessionProvider {
    protected IdentityService identityService;

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Override
    public Session getSession(HttpServletRequest request, HttpServletResponse response) {
        return getSession(getToken(request));
    }

    protected Session getSession(final String token) {
        return new AbstractSession(token) {
            private static final long serialVersionUID = 5202907618308057498L;

            @Override
            protected String internalGetGlobalToken() {
                return identityService.createGlobalToken(getUserId(), null);
            }

            @Override
            protected String internalGetUserId() {
                String userId = identityService.getUserIdByToken(getToken());
                return userId;
            }

            @Override
            protected Set<Role> internalGetRoles() {
                return identityService.getUserRoles(getUserId());
            }

            @Override
            protected User internalGetUser() {
                return identityService.getUser(getUserId());
            }

            @Override
            public String getIp() {
                return getAttr(Constants.IP);
            }

            @Override
            public boolean isGuest() {
                return StringUtils.isBlank(getUserId());
            }
        };
    }

    protected String getToken(HttpServletRequest request) {
        String token = null;
        Cookie cookie = WebUtils.getCookie(request, Constants.TOKEN);
        if (cookie != null) {
            token = cookie.getValue();
        }
        if (token == null) {
            token = RequestUtils.getParameter(request, Constants.TOKEN);
        }
        if (token == null) {
            token = request.getHeader(Constants.TOKEN);
        }
        return StringUtils.trimToNull(token);
    }
}
