/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SecurityContext.java
 * Modifier: yangxin
 * Modified: 2014-06-11 19:37
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;


import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.attr.Attrs;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-11
 */
public final class SecurityContext {

    private static ThreadLocal<SecurityContext> LOCAL = new InheritableThreadLocal<SecurityContext>() {
        @Override
        protected SecurityContext initialValue() {
            return new SecurityContext();
        }
    };

    private Session session;
    private Attrable attr = Attrs.newJSONAttrable();

    public static SecurityContext getContext() {
        return LOCAL.get();
    }

    public static void clearContext() {
        LOCAL.remove();
    }

    public Session getSession() {
        return session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Attrable getAttr() {
        return attr;
    }

    private SecurityContext() {
    }
}
