/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Sec.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;


import cn.gtmap.egovplat.security.ex.NoPermissonException;
import cn.gtmap.egovplat.security.impl.SimpleRole;

import java.util.Collection;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-11
 */
public final class Sec {

    public static Session getSession() {
        Session session = SecurityContext.getContext().getSession();
        if (session == null) {
            throw new SecurityException("Session not found");
        }
        return session;
    }

    public static boolean hasSession() {
        return SecurityContext.getContext().getSession() != null;
    }

    public static User getUser() {
        return getSession().getUser();
    }



    public static String getUserId() {
        return getSession().getUserId();
    }



    public static String getToken() {
        Session session = SecurityContext.getContext().getSession();
        return session == null ? null : session.getToken();
    }

    public static String getGlobalToken() {
        Session session = SecurityContext.getContext().getSession();
        return session == null ? null : session.getGlobalToken();
    }

    public static Set<Role> getRoles() {
        return getSession().getRoles();
    }

    public static boolean hasRole(String roleName) {
        return getRoles().contains(new SimpleRole(roleName));
    }

    public static boolean hasRoles(Collection<String> roleNames) {
        Set<Role> userRoles = getRoles();
        for (String roleName : roleNames) {
            if (!userRoles.contains(new SimpleRole(roleName))) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasAnyRoles(Collection<String> roleNames) {
        Set<Role> userRoles = getRoles();
        for (String roleName : roleNames) {
            if (userRoles.contains(new SimpleRole(roleName))) {
                return true;
            }
        }
        return false;
    }

    public static boolean lacksRole(String roleName) {
        return !hasRole(roleName);
    }

    public static boolean lacksRoles(Collection<String> roleNames) {
        Set<Role> userRoles = getRoles();
        for (String roleName : roleNames) {
            if (userRoles.contains(new SimpleRole(roleName))) {
                return false;
            }
        }
        return true;
    }



    public static boolean isGuest() {
        return getSession().isGuest();
    }

    public static boolean isAdmin() {
        return getRoles().contains(Constants.ROLE_ADMIN);
    }

    private Sec() {
    }
}
