/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     GlobalToken.java
 * Modifier: yangxin
 * Modified: 2014-06-11 19:18
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.security.ex.SecException;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
public final class GlobalToken {
    private String userId;
    private Date expire;
    private Set<String> resources = Sets.newHashSet();

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public Set<String> getResources() {
        return resources;
    }

    public void addResources(Collection<String> resources) {
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(userId);
        sb.append(",").append(expire.getTime());
        for (String res : resources) {
            sb.append(",").append(res);
        }
        return sb.toString();
    }

    public static GlobalToken fromString(String s) {
        String[] arr = StringUtils.split(s, ',');
        if (arr.length < 2) {
            throw new SecException("Invalid global token:[" + s + "]");
        }
        GlobalToken globalToken = new GlobalToken();
        globalToken.setUserId(arr[0]);
        globalToken.setExpire(new Date(Long.valueOf(arr[1])));
        if (arr.length > 2) {
            globalToken.addResources(Arrays.asList(arr).subList(2, arr.length));
        }
        return globalToken;
    }
}
