package cn.gtmap.egovplat.model.manage;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import com.google.common.collect.Sets;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import java.util.List;
import java.util.Set;

/**
 * 子系统
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/3/27
 */
@Entity
@Table(name = "pf_subsystem")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Subsystem extends BaseEntity{

    @Column(length = 50, nullable = false)
    @NaturalId
    @Field("子系统名称")
    private String name;

    @Column(length = 200, nullable = false)
    @Field("子系统别名")
    private String viewName;

    @Column(length = 500)
    @Field("子系统名称")
    private String remark;

    @ManyToMany(mappedBy = "subsystems")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private Set<Menu> menus= Sets.newHashSet();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Set<Menu> getMenus() {
        return menus;
    }

    public void setMenus(Set<Menu> menus) {
        this.menus = menus;
    }
}
