package cn.gtmap.egovplat.model.manage;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import com.google.common.collect.Sets;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.*;
import java.util.Set;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/1
 */
@Entity
@Table(name = "pf_resource")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Resource extends BaseEntity {
    @Column(length = 200, nullable = false)
    @NaturalId
    @Field("资源名称")
    private String name;

    @Column(length = 50, nullable = false)
    @Field("资源编号")
    private String code;

    @Column(precision = 2, nullable = false)
    @Field("资源类型")
    private int type;

    @Column(precision = 2, nullable = false)
    @Field("资源加载方式")
    private int loadMode;

    @Column(length = 500)
    @Field("资源Url")
    private String url;

    @OneToMany(mappedBy = "resource",cascade = CascadeType.ALL)
    @OrderBy("code")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private Set<Menu> menus= Sets.newHashSet();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLoadMode() {
        return loadMode;
    }

    public void setLoadMode(int loadMode) {
        this.loadMode = loadMode;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Set<Menu> getMenus() {
        return menus;
    }

    public void setMenus(Set<Menu> menus) {
        this.menus = menus;
    }
}
