package cn.gtmap.egovplat.model.manage;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.*;
import java.util.List;
import java.util.Set;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/3/27
 */
@Entity
@Table(name = "pf_menu")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Menu extends BaseEntity {

    @Column(length = 200, nullable = false)
    @NaturalId
    @Field("菜单名称")
    private String name;

    @Column(length = 50, nullable = false)
    @Field("菜单编号")
    private String code;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("父菜单")
    private Menu parent;

    @OneToMany(mappedBy = "parent", cascade = CascadeType.ALL)
    @OrderBy("code")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("子菜单列表")
    private List<Menu> children = Lists.newArrayList();

    @Column(length = 100)
    @Field("菜单图标样式")
    private String cssStyle;

    @Column(precision = 1, nullable = false,columnDefinition = "NUMBER DEFAULT 0")
    @Field(value = "菜单默认是否展开")
    private Boolean expanded;

    @Column(precision = 1, nullable = false,columnDefinition = "NUMBER DEFAULT 0")
    @Field(value = "菜单打开方式")
    private int openStyle;

    @ManyToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE})
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @JoinTable(name = "pf_menu_subsystem", joinColumns = @JoinColumn(name = "menu_id"), inverseJoinColumns = {@JoinColumn(name = "subsystem_id")})
    @Field("子系统列表")
    private Set<Subsystem> subsystems = Sets.newHashSet();

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resource_id")
    @Field("菜单对应的资源")
    private Resource resource;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Menu getParent() {
        return parent;
    }

    public void setParent(Menu parent) {
        this.parent = parent;
    }

    public List<Menu> getChildren() {
        return children;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    public String getCssStyle() {
        return cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public Boolean isExpanded() {
        return expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    public int getOpenStyle() {
        return openStyle;
    }

    public void setOpenStyle(int openStyle) {
        this.openStyle = openStyle;
    }

    public Set<Subsystem> getSubsystems() {
        return subsystems;
    }

    public void setSubsystems(Set<Subsystem> subsystems) {
        this.subsystems = subsystems;
    }

    public Resource getResource() {
        return resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}
