/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DefaultUser.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.model.identity;

import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.bean.Attrable;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;
import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.bean.DictItemable;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import cn.gtmap.egovplat.core.support.hibernate.JSONType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Entity
@Table(name = "pf_user")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Resource(key = "User", name = "人员")
public class User extends BaseEntity implements cn.gtmap.egovplat.security.User, Comparable<User> {
    private static final long serialVersionUID = 1482026265347925256L;
    @Column(length = 256, nullable = false)
    @NaturalId
    @Field("名称")
    private String name;
    @Column(length = 256)
    @Field("别名")
    private String viewName;
    @Column(length = 64)
    @Field("密码")
    private String password;
    @Column(length = 32)
    @Field("代码")
    private String code;
    @Column(precision = 2)
    @Field("性别")
    private String gender;
    @Column(length = 10)
    @Field("级别")
    private String grade;

    @Temporal(TemporalType.TIMESTAMP)
    @Field("生日")
    private Date birthday;
    @Column(length = 256)
    @Field("头像")
    private String avatar;
    @Column(length = 64)
    @Field("电子邮件")
    private String email;
    @Column(length = 16)
    @Field("移动电话")
    private String mobile;
    @Column(length = 16)
    @Field("固定电话")
    private String tel;
    @Column(length = 1024)
    @Field("说明")
    private String description;

    @Column(length = 64)
    @Field("原始用户id")
    private String rawId;
    @Column(length = 32)
    @Field("渠道来源")
    private String channel;

    @Type(type = JSONType.TYPE)
    @Column(length = 4000)
    private Attrable attr = Attrs.newJSONAttrable();
    @Type(type = JSONType.TYPE)
    @Column(length = 4000)
    private Attrable prefs = Attrs.newJSONAttrable();

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "creator_id")
    @Field("创建者")
    private User creator;
    @ManyToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE})
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @JoinTable(name = "pf_user_role", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = {@JoinColumn(name = "role_id")})
    @Field("角色列表")
    private Set<Role> roles = Sets.newHashSet();
    @ManyToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE})
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @JoinTable(name = "pf_user_department", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = {@JoinColumn(name = "department_id")})
    @Field("部门列表")
    private Set<Department> departments = Sets.newHashSet();

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getPassword() {
        return password;
    }

    @JSONField(serialize = false)
    public void setPassword(String password) {
        this.password = password;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }





    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JSONField(serialize = false)
    public String getRawId() {
        return rawId;
    }

    public void setRawId(String rawId) {
        this.rawId = rawId;
    }

    @JSONField(serialize = false)
    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JSONField(serialize = false)
    public Attrable getAttr() {
        return attr;
    }

    public void setAttr(Attrable attr) {
        this.attr = attr;
    }

    @JSONField(serialize = false)
    public Attrable getPrefs() {
        return prefs;
    }

    public void setPrefs(Attrable prefs) {
        this.prefs = prefs;
    }

    @JSONField(serialize = false)
    public User getCreator() {
        return creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    @JSONField(serialize = false)
    public Set<Role> getRoles() {
        return roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @JSONField(serialize = false)
    public Set<Department> getDepartments() {
        return departments;
    }

    public void setDepartments(Set<Department> departments) {
        this.departments = departments;
    }



    public void addRole(Role role) {
        getRoles().add(role);
        role.getUsers().add(this);
    }

    public void addDepartment(Department department) {
        getDepartments().add(department);
        department.getUsers().add(this);
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    @Override
    public int compareTo(User o) {
        return o.name.compareTo(name);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof User && name.equals(((User) obj).name);
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return "User [" + getId() + "," + name + "]";
    }
}
