/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Department.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.model.identity;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.bean.DictItemable;
import cn.gtmap.egovplat.core.bean.Orderable;
import cn.gtmap.egovplat.core.bean.TreeNode;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import cn.gtmap.egovplat.core.util.TreePathBuilder;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.util.List;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Entity
@Table(name = "pf_department")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Resource(key = "Department", name = "部门信息")
public class Department extends BaseEntity implements DictItemable, Orderable, TreeNode<Department>, Comparable<Department> {
    private static final long serialVersionUID = -5143133284753258524L;
    @Column(length = 256, nullable = false)
    @Field("名称")
    private String name;
    @Column(length = 32)
    @Field("代码")
    private String code;
    @Column(length = 256)
    @Field("说明")
    private String description;
    @Column(precision = 5, nullable = false)
    @Field("权重")
    private int weight;
    @Column(length = 1024, nullable = false)
    private String path;

    @Column(length = 32)
    @Field("法人")
    private String owner;
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("父部门")
    private Department parent;
    @OneToMany(mappedBy = "parent", cascade = CascadeType.ALL)
    @OrderBy("weight")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("子部门列表")
    private List<Department> children = Lists.newArrayList();
    @ManyToMany(mappedBy = "departments")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("用户列表")
    private Set<User> users = Sets.newHashSet();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getWeight() {
        return weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @JSONField(serialize = false)
    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    @JSONField(serialize = false)
    public Department getParent() {
        return parent;
    }

    public void setParent(Department parent) {
        this.parent = parent;
    }

    @Override
    @JSONField(serialize = false)
    public List<Department> getChildren() {
        return children;
    }

    public void setChildren(List<Department> children) {
        this.children = children;
    }

    @Override
    public Department getChild(int index) {
        if (children != null && !children.isEmpty() && children.size() > index) {
            return children.get(index);
        } else {
            return null;
        }
    }

    @Override
    @JSONField(serialize = false)
    public Department getFirst() {
        return getChild(0);
    }

    @Override
    @JSONField(serialize = false)
    public Department getLast() {
        return getChild(children.size() - 1);
    }

    @Override
    @JSONField(serialize = false)
    public int getChildCount() {
        return children.size();
    }

    @Override
    @JSONField(serialize = false)
    public boolean isRoot() {
        return parent == null;
    }

    @Override
    public boolean hasChild() {
        return !children.isEmpty();
    }

    @JSONField(serialize = false)
    public Set<User> getUsers() {
        return users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    @Override
    @JSONField(serialize = false)
    public String getKey() {
        return name;
    }

    @Override
    public String getItemKey() {
        return getId();
    }

    @Override
    public String getItemValue() {
        return getName();
    }

    @Override
    public int compareTo(Department o) {
        return o.getWeight() - weight;
    }

    @PrePersist
    public void init() {
        if (isNew()) {
            setWeight(hasChild() ? getLast().getWeight() + 1 : 1);
            setPath(new TreePathBuilder<Department>() {
                @Override
                protected String getId(Department dept) {
                    return dept.getId();
                }
            }.build(this));
        }
    }
}
