package cn.gtmap.egovplat.model.bpm;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 流程定义对象
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/18
 */
@Entity
@Table(name = "pf_process_definition")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ProcessDefine extends BaseEntity {

    @Column(length = 64)
    @Field("bpm工作流引擎中的流程定义Id")
    private String bpmProcDefId;

    @Column(length = 255, nullable = false)
    @NaturalId
    @Field("bpm工作流引擎中的流程定义Key")
    private String bpmProcDefKey;

    @Column(precision = 1,columnDefinition = "INTEGER DEFAULT 0")
    @Field("bpm流程引擎中的流程定义Version")
    private Integer bpmProcDefVersion;

    @Column(length = 64)
    @Field("bpm工作流引擎中的流程定义的模型Id")
    private String bpmProcDefModelId;

    @Column(length = 50, nullable = false)
    @Field("流程定义名称")
    private String procDefName;

    @Column(length = 255)
    @Field("流程定义描述")
    private String procDefDescription;

    public String getBpmProcDefId() {
        return bpmProcDefId;
    }

    public void setBpmProcDefId(String bpmProcDefId) {
        this.bpmProcDefId = bpmProcDefId;
    }

    public String getBpmProcDefKey() {
        return bpmProcDefKey;
    }

    public void setBpmProcDefKey(String bpmProcDefKey) {
        this.bpmProcDefKey = bpmProcDefKey;
    }

    public String getBpmProcDefModelId() {
        return bpmProcDefModelId;
    }

    public void setBpmProcDefModelId(String bpmProcDefModelId) {
        this.bpmProcDefModelId = bpmProcDefModelId;
    }

    public String getProcDefName() {
        return procDefName;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    public Integer getBpmProcDefVersion() {
        return bpmProcDefVersion;
    }

    public void setBpmProcDefVersion(Integer bpmProcDefVersion) {
        this.bpmProcDefVersion = bpmProcDefVersion;
    }

    public String getProcDefDescription() {
        return procDefDescription;
    }

    public void setProcDefDescription(String procDefDescription) {
        this.procDefDescription = procDefDescription;
    }
}
