package cn.gtmap.egovplat.model.bpm;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.*;
import java.util.List;

/**
 * 业务分类
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/3/27
 */
@Entity
@Table(name = "pf_business")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Business  extends BaseEntity {
    @Column(length = 200, nullable = false)
    @NaturalId
    @Field("业务名称")
    private String name;

    @Column(length = 50, nullable = false)
    @Field("业务编号")
    private String code;


    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("父业务")
    private Business parent;

    @OneToMany(mappedBy = "parent", cascade = CascadeType.ALL)
    @OrderBy("code")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field("子业务列表")
    private List<Business> children = Lists.newArrayList();


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JSONField(serialize = false)
    public Business getParent() {
        return parent;
    }

    public void setParent(Business parent) {
        this.parent = parent;
    }

    @JSONField(serialize = false)
    public List<Business> getChildren() {
        return children;
    }

    public void setChildren(List<Business> children) {
        this.children = children;
    }
}
