/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ValidationSourceAdvisor.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:46
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.validation.interceptor;


import cn.gtmap.egovplat.core.validation.Validate;
import cn.gtmap.egovplat.core.validation.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.annotation.BeanValidationAnnotationsConfigurer;
import net.sf.oval.configuration.annotation.JPAAnnotationsConfigurer;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.guard.GuardInterceptor;
import net.sf.oval.guard.Guarded;
import net.sf.oval.internal.Log;
import net.sf.oval.logging.LoggerFactorySLF4JImpl;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.beans.factory.InitializingBean;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-28
 */
public class ValidationSourceAdvisor extends AbstractBeanFactoryPointcutAdvisor implements InitializingBean {
    private static final long serialVersionUID = 8448761854101833695L;
    private Validator validator;
    private ExceptionTranslator exceptionTranslator;
    private LinkedList<Configurer> configurers = new LinkedList<Configurer>();
    private boolean enableAll;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setConfigurers(List<Configurer> configurers) {
        this.configurers.addAll(configurers);
    }

    public void setEnableAll(boolean enableAll) {
        this.enableAll = enableAll;
    }

    private final Pointcut pointcut = new StaticMethodMatcherPointcut() {

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return (enableAll || targetClass.isAnnotationPresent(Guarded.class) || targetClass.isAnnotationPresent(Validate.class)) && validator.needValidate(method, targetClass);
        }
    };

    @Override
    public Pointcut getPointcut() {
        return pointcut;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Log.setLoggerFactory(new LoggerFactorySLF4JImpl());
        if (validator == null) {
            configurers.addFirst(new BeanValidationAnnotationsConfigurer());
            configurers.addFirst(new JPAAnnotationsConfigurer());
            configurers.addFirst(new AnnotationsConfigurer());
            validator = new Validator(configurers);
            if (exceptionTranslator == null) {
                exceptionTranslator = new AppExceptionTranslator();
            }
            validator.setExceptionTranslator(exceptionTranslator);
        }
        if (getAdvice() == null && getAdviceBeanName() == null) {
            setAdvice(new GuardInterceptor(validator));
        }
    }
}
