/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     TreePathBuilder.java
 * Modifier: yangxin
 * Modified: 2014-06-24 09:23
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.util;

import cn.gtmap.egovplat.core.bean.TreeNode;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-24
 */
public abstract class TreePathBuilder<E extends TreeNode<E>> {

    public String build(E node) {
        StringBuilder sb = new StringBuilder();
        E parent = node.getParent();
        if (parent == null) {
            sb.append("/");
        }
        while (parent != null) {
            sb.append(getId(parent)).append("/");
            parent = parent.getParent();
        }
        return sb.reverse().toString();
    }

    protected abstract String getId(E node);
}
