/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EnumUtils.java
 * Modifier: yangxin
 * Modified: 2014-06-11 21:48
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.util;

import cn.gtmap.egovplat.core.bean.Titleable;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
public final class EnumUtils extends org.apache.commons.lang3.EnumUtils {

    public static <E extends Enum<E>> Map<String, String> getDictMap(Class<E> enumClass, int start) {
        Map<String, String> map = new LinkedHashMap<String, String>();
        for (final E e : enumClass.getEnumConstants()) {
            if (start-- > 0) {
                continue;
            }
            map.put(e.name(), e instanceof Titleable ? ((Titleable) e).getTitle() : e.name());
        }
        return map;
    }

    public static <E extends Enum<E>> Map<String, String> getDictMap(Class<E> enumClass) {
        return getDictMap(enumClass, 0);
    }

    public static <E extends Enum<E>> E valueOf(Class<E> enumClass, String name) {
        try {
            return Enum.valueOf(enumClass, name.toUpperCase());
        } catch (Exception e) {
            return null;
        }
    }

    public static <E extends Enum<E>> Map<Integer, String> getDicIndextMap(Class<E> enumClass, int start) {
        Map<Integer, String> map = new LinkedHashMap<Integer, String>();
        for (final E e : enumClass.getEnumConstants()) {
            if (start-- > 0) {
                continue;
            }
            map.put(e.ordinal(), e instanceof Titleable ? ((Titleable) e).getTitle() : e.name());
        }
        return map;
    }

    public static <E extends Enum<E>> Map<Integer, String> getDictIndexMap(Class<E> enumClass) {
        return getDicIndextMap(enumClass, 0);
    }
}
