/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DateConverter.java
 * Modifier: yangxin
 * Modified: 2014-06-13 22:51
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.util.DateUtils;
import org.springframework.core.convert.converter.Converter;

import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-13
 */
public class StringToDateConverter implements Converter<String, Date> {
    @Override
    public Date convert(String source) {
        return DateUtils.parse(source);
    }
}
