/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SitemeshHelper.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.core.support.sitemesh;

import com.google.common.collect.Maps;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProperty;
import org.sitemesh.content.memory.InMemoryContent;
import org.sitemesh.webapp.WebAppContext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 11-11-24
 */
public class SitemeshHelper {

    public static void extractMeta(PageContext context) {
        Content content = (Content) context.getRequest().getAttribute(WebAppContext.CONTENT_KEY);
        if (content == null) {
            content = new InMemoryContent();
        }
        ContentProperty cp = content.getExtractedProperties();
        context.setAttribute("_base", ((HttpServletRequest) context.getRequest()).getContextPath());
        context.setAttribute("_body", cp.getChild("body").getValue());
        context.setAttribute("_title", cp.getChild("title").getValue());
        context.setAttribute("_head", cp.getChild("head").getValue());
        Map<String, String> metaMap = Maps.newHashMap();
        for (ContentProperty cp1 : cp.getChild("meta").getChildren()) {
            metaMap.put(cp1.getName(), cp1.getValue());
        }
        context.setAttribute("_meta", metaMap);
    }
}
