/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     JPAHelper.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.jpa;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jpa.HibernateEntityManager;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-11-13
 */
public final class JPAHelper {

    public static EntityManager getEntityManager(EntityManagerFactory entityManagerFactory) {
        return EntityManagerFactoryUtils.getTransactionalEntityManager(entityManagerFactory);
    }

    public static SessionFactory getSessionFactory(EntityManagerFactory entityManagerFactory) {
        return ((HibernateEntityManagerFactory) entityManagerFactory).getSessionFactory();
    }

    public static Session getSession(EntityManagerFactory entityManagerFactory) {
        return ((HibernateEntityManager) EntityManagerFactoryUtils.getTransactionalEntityManager(entityManagerFactory)).getSession();
    }

    public static Session getSession(SessionFactory sessionFactory) {
        return sessionFactory.getCurrentSession();
    }

    @SuppressWarnings("unchecked")
    public static <T> T getId(SessionFactory sessionFactory, Object entity) {
        ClassMetadata classMetadata = sessionFactory.getClassMetadata(entity.getClass());
        if (classMetadata != null) {
            return (T) classMetadata.getIdentifier(entity, (SessionImplementor) getSession(sessionFactory));
        }
        return null;
    }

    public static void clearL1Cache(EntityManagerFactory entityManagerFactory) {
        getSession(entityManagerFactory).clear();
    }

    private JPAHelper() {
    }
}
