/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     RepoFactoryBean.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.entity.Repo;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import javax.persistence.EntityManagerFactory;
import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
public class RepoFactoryBean<E, ID extends Serializable> implements FactoryBean<Repo<E, ID>>, InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private SessionFactory sessionFactory;
    private Class<E> entityClass;
    private Repo<E, ID> repo;

    @Autowired(required = false)
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Autowired(required = false)
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public Repo<E, ID> getObject() throws Exception {
        return repo;
    }

    @Override
    public Class<?> getObjectType() {
        return Repo.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(entityClass, "entityClass is required,it must not be null");
        Assert.isTrue(entityManagerFactory != null || sessionFactory != null, "entityManagerFactory or sessionFactory is required,it must not be null");

        HibernateRepo<E, ID> repo = createRepo(entityClass);

        if (entityManagerFactory != null) {
            repo.setEntityManagerFactory(entityManagerFactory);
        } else if (sessionFactory != null) {
            repo.setSessionFactory(sessionFactory);
        }
        this.repo = repo;
    }

    @SuppressWarnings("unchecked")
    protected HibernateRepo<E, ID> createRepo(Class<E> entityClass) {
        return new HibernateRepo(entityClass);
    }
}
