/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Oracle10gDialect.java
 * Modifier: yangxin
 * Modified: 2014-06-12 20:06
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.hibernate;

import org.hibernate.HibernateException;

import java.sql.Types;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-12
 */
public class Oracle10gDialect extends org.hibernate.dialect.Oracle10gDialect {

    @Override
    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        switch (code) {
            case Types.INTEGER:
                if (precision > 0 && precision < 10) {
                    return "number(" + precision + ",0)";
                }
            case Types.BIGINT:
                if (precision > 0 && precision < 19) {
                    return "number(" + precision + ",0)";
                }
        }
        return super.getTypeName(code, length, precision, scale);
    }
}
