/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Hibernates.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.core.support.hibernate;

import com.google.common.collect.Maps;
import org.hibernate.Hibernate;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-8-17
 */
@SuppressWarnings("unchecked")
public class Hibernates {
    private Hibernates() {
    }

    public static void init(Object proxy) {
        Hibernate.initialize(proxy);
    }

    public static int getInt(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number) o).intValue();
    }

    public static long getLong(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number) o).longValue();
    }

    public static float getFloat(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number) o).floatValue();
    }

    public static double getDouble(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number) o).doubleValue();
    }

    public static Map<String, Integer> toStringIntMap(List list) {
        Map<String, Integer> map = Maps.newHashMap();
        for (Object[] arr : (List<Object[]>) list) {
            map.put((String) arr[0], getInt(arr[1]));
        }
        return map;
    }

    public static Map<Long, Integer> toLongIntMap(List list) {
        Map<Long, Integer> map = Maps.newHashMap();
        for (Object[] arr : (List<Object[]>) list) {
            map.put(getLong(arr[0]), getInt(arr[1]));
        }
        return map;
    }

    public static Map<String, Float> toStringFloatMap(List list) {
        Map<String, Float> map = Maps.newHashMap();
        for (Object[] arr : (List<Object[]>) list) {
            map.put((String) arr[0], getFloat(arr[1]));
        }
        return map;
    }

    public static Map<String, Double> toStringDoubleMap(List list) {
        Map<String, Double> map = Maps.newHashMap();
        for (Object[] arr : (List<Object[]>) list) {
            map.put((String) arr[0], getDouble(arr[1]));
        }
        return map;
    }

    public static Map<Long, Double> toLongDoubleMap(List list) {
        Map<Long, Double> map = Maps.newHashMap();
        for (Object[] arr : (List<Object[]>) list) {
            map.put((Long) arr[0], getDouble(arr[1]));
        }
        return map;
    }
}
