/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ViewTypes.java
 * Modifier: yangxin
 * Modified: 2014-06-11 18:48
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.model;

import com.google.common.collect.Sets;

import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
public final class Views {

    public static final String WORD = "word";
    public static final String HIDDEN = "hidden";
    public static final String TEXT = "text";
    public static final String PASSWORD = "password";
    public static final String NUMBER = "number";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String FILE = "file";
    public static final String EMAIL = "email";
    public static final String URL = "url";
    public static final String COLOR = "color";
    public static final String RANGE = "range";
    public static final String SEARCH = "search";
    public static final String TEXTAREA = "textarea";
    public static final String RICHEDIT = "richedit";
    public static final String SELECT = "select";
    public static final String COMBO = "combo";
    public static final String RCOMBO = "rcombo";
    public static final String CHECKBOX = "checkbox";
    public static final String RADIO = "radio";
    public static final String SWITCH = "switch";
    public static final Set<String> NO_VALIDATE = Sets.newHashSet(WORD, HIDDEN);
    public static final Set<String> INPUTS = Sets.newHashSet(TEXT, PASSWORD, NUMBER, DATE, DATETIME, FILE, EMAIL, URL, COLOR, RANGE, SEARCH);

    public static boolean needValidate(String view) {
        return !NO_VALIDATE.contains(view);
    }

    public static boolean useInput(String view) {
        return INPUTS.contains(view);
    }
}
