/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Point.java
 * Modifier: yangxin
 * Modified: 2014-06-13 10:17
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.gis;

import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-8
 */
public class Point implements Serializable, Cloneable {
    private static final long serialVersionUID = 968060969970685635L;
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point() {
    }

    public double getX() {
        return x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return y;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Point)) {
            return false;
        }
        Point otherPoint = (Point) obj;
        return x == otherPoint.getX() &&
                y == otherPoint.getY();
    }

    @Override
    public int hashCode() {
        int hashCode = 17;
        long lng = Double.doubleToLongBits(x);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        lng = Double.doubleToLongBits(y);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        return hashCode;
    }

    @Override
    public Point clone() {
        try {
            return (Point) super.clone();
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return x + " " + y;
    }
}
