/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EsriUnits.java
 * Modifier: yangxin
 * Modified: 2014-06-13 10:22
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.gis;

import cn.gtmap.egovplat.core.bean.Titleable;
import org.apache.commons.lang3.StringUtils;

import javax.measure.quantity.Length;
import javax.measure.unit.BaseUnit;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-16
 */
public enum EsriUnits implements Titleable {
    esriUnknownUnits("esriUnknownUnits"),
    esriInches("esriInches"),
    esriPoints("esriPoints"),
    esriFeet("esriFeet"),
    esriYards("esriYards"),
    esriMiles("esriMiles"),
    esriNauticalMiles("esriNauticalMiles"),
    esriMillimeters("esriMillimeters"),
    esriCentimeters("esriCentimeters"),
    esriMeters("esriMeters"),
    esriKilometers("esriKilometers"),
    esriDecimalDegrees("esriDecimalDegrees"),
    esriDecimeters("esriDecimeters");

    private String title;

    EsriUnits(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /**
     * 从BaseUnit生成ESRIUnits，通过GeoTools来解析wkt空间参考时使用
     * @param unit 需要转换的BaseUnit对象
     * @return 转换后的ESRIUnits对象
     */
    public static EsriUnits fromBaseUnit(BaseUnit<Length> unit) {
        String symbol = unit.getSymbol();
        if (StringUtils.equals(symbol, "m"))
            return EsriUnits.esriMeters;
        else if (StringUtils.equals(symbol, "Decimal Degree"))
            return EsriUnits.esriDecimalDegrees;
        else
            return EsriUnits.esriMeters;
    }
}
