/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Bound.java
 * Modifier: yangxin
 * Modified: 2014-06-13 10:17
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.gis;

import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-3-26
 */
public class Bound implements Serializable, Cloneable {
    private static final long serialVersionUID = -6318155667738393620L;
    /**
     * the minimum x-coordinate
     */
    private double xmin;

    /**
     * the maximum x-coordinate
     */
    private double xmax;

    /**
     * the minimum y-coordinate
     */
    private double ymin;

    /**
     * the maximum y-coordinate
     */
    private double ymax;

    public Bound(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public Bound() {
    }

    public double getXmin() {
        return xmin;
    }

    public void setXmin(double xmin) {
        this.xmin = xmin;
    }

    public double getXmax() {
        return xmax;
    }

    public void setXmax(double xmax) {
        this.xmax = xmax;
    }

    public double getYmin() {
        return ymin;
    }

    public void setYmin(double ymin) {
        this.ymin = ymin;
    }

    public double getYmax() {
        return ymax;
    }

    public void setYmax(double ymax) {
        this.ymax = ymax;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Bound)) {
            return false;
        }
        Bound otherBound = (Bound) obj;
        return xmin == otherBound.getXmin() &&
                xmax == otherBound.getXmax() &&
                ymin == otherBound.getYmin() &&
                ymax == otherBound.getYmax();
    }

    @Override
    public int hashCode() {
        int hashCode = 17;
        long lng = Double.doubleToLongBits(xmin);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        lng = Double.doubleToLongBits(xmax);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        lng = Double.doubleToLongBits(ymin);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        lng = Double.doubleToLongBits(ymax);
        hashCode = 37 * hashCode + ((int) (lng ^ (lng >> 32)));
        return hashCode;
    }

    @Override
    public Bound clone() {
        try {
            return (Bound) super.clone();
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return xmin + " " + ymin + " " + xmax + " " + ymax;
    }
}
