/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityException.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.ex;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-8-14
 */
public class EntityException extends AppException {
    private static final long serialVersionUID = -4686633812095775678L;

    public EntityException(Class clazz, String msg, Throwable cause) {
        super(cause, ENTITY_EX, clazz.getSimpleName(), msg);
    }

    public EntityException(Class clazz, String msg) {
        this(clazz, msg, null);
    }

    public EntityException(Class clazz, Throwable cause) {
        this(clazz, null, cause);
    }

    public EntityException(int code, Object... args) {
        super(code, args);
    }

    public EntityException(Throwable cause, int code, Object... args) {
        super(cause, code, args);
    }

    public EntityException(String defaultMessage, int code, Object... args) {
        super(defaultMessage, code, args);
    }

    public EntityException(String defaultMessage, Throwable cause, int code, Object... args) {
        super(defaultMessage, cause, code, args);
    }
}
