/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ContextLoaderListener.java
 * Modifier: yangxin
 * Modified: 2014-06-11 14:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.env;

import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.CachedIntrospectionResults;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-9-22
 */
public class ContextLoaderListener extends org.springframework.web.context.ContextLoaderListener implements ServletContextListener {

    @Override
    public void contextInitialized(ServletContextEvent event) {
        //init global config
        EnvConfLoader.load();
        if (!Env.has(Env.APP_URL)) {
            Env.setAttr(Env.APP_URL, event.getServletContext().getContextPath());
        }
        //adapt jul
        SLF4JBridgeHandler.install();
        //fix memleak
        CachedIntrospectionResults.acceptClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            super.contextInitialized(event);
            Env.started = true;
        } catch (Throwable ignored) {
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent event) {
        try {
            super.contextDestroyed(event);
        } finally {
            Env.started = false;
            SLF4JBridgeHandler.uninstall();
            CachedIntrospectionResults.clearClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }
}
