/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AbstractEntity.java
 * Modifier: yangxin
 * Modified: 2013-06-14 10:30
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.entity;

import cn.gtmap.egovplat.core.bean.*;
import cn.gtmap.egovplat.core.model.Views;
import cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator;
import com.alibaba.fastjson.annotation.JSONField;
import cn.gtmap.egovplat.core.annotation.Field;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-2-28
 */
@MappedSuperclass
public abstract class BaseEntity implements  Serializable {
    private static final long serialVersionUID = 8720971856106617968L;
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = UUIDHexGenerator.TYPE)
    @Column(length = 32)
    @Field(value = "序号", view = Views.HIDDEN)
    private String id;

    @Column(precision = 1, nullable = false)
    @Field(value = "状态", view = Views.SWITCH)
    private Status status = Status.ENABLED;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    @Field("创建时间")
    private Date createAt;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    @Field("更新时间")
    private Date updateAt;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JSONField(serialize = false)
    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Date getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }


    @JSONField(serialize = false)
    public boolean isEnabled() {
        return status == Status.ENABLED;
    }

    @JSONField(serialize = false)
    public boolean isNew() {
        return StringUtils.isEmpty(id);
    }

    @JSONField(serialize = false)
    public String getKey() {
        return isNew() ? String.valueOf(super.hashCode()) : id;
    }

    @Override
    public int hashCode() {
        return getKey().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof BaseEntity && getKey().equals(((BaseEntity) o).getKey());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
