/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     RSAKeyHelper.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.encrypt;


import cn.gtmap.egovplat.core.util.Codecs;

import java.security.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-8-23
 */
public class RSAKeyHelper {
    public static void main(String[] args) throws Exception {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = new SecureRandom();
        if (args.length > 1) {
            random.setSeed(args[1].getBytes("utf-8"));
        } else {
            random.setSeed(random.nextLong());
        }
        keygen.initialize(1024, random);
        KeyPair kp = keygen.generateKeyPair();
        PublicKey publicKey = kp.getPublic();
        PrivateKey privateKey = kp.getPrivate();
        System.out.println("------------------------- publicKey ------------------------");
        System.out.println(Codecs.encode(publicKey.getEncoded()));
        System.out.println("------------------------- privateKey ------------------------");
        System.out.println(Codecs.encode(privateKey.getEncoded()));
        System.out.println("-------------------------------------------------------------");
    }
}
