/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     MatchMode.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data.dsl;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-6-21
 */
public enum MatchMode {
    EXACT {
        public String toMatchString(String pattern) {
            return pattern;
        }
    },
    START {
        public String toMatchString(String pattern) {
            return pattern + '%';
        }
    },
    END {
        public String toMatchString(String pattern) {
            return '%' + pattern;
        }
    },
    ANYWHERE {
        public String toMatchString(String pattern) {
            return '%' + pattern + '%';
        }
    };

    public abstract String toMatchString(String pattern);
}
