/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DSL.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data.dsl;

import cn.gtmap.egovplat.core.util.Pair;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-6-21
 */
@SuppressWarnings("rawtypes")
public final class DSL {

    public static Criterion and(Criterion... criterions) {
        return c().and(criterions);
    }

    public static Criterion or(Criterion... criterions) {
        return c().or(criterions);
    }

    public static Criterion expr(String... exprs) {
        return c().expr(exprs);
    }

    public static Criterion isNull(String name) {
        return c().isNull(name);
    }

    public static Criterion notNull(String name) {
        return c().notNull(name);
    }

    public static Criterion empty(String name) {
        return c().empty(name);
    }

    public static Criterion notEmpty(String name) {
        return c().notEmpty(name);
    }

    public static Criterion eq(String name, Object value) {
        return c().eq(name, value);
    }

    public static Criterion eqIf(String name, Object value, boolean... conditions) {
        return c().eqIf(name, value, conditions);
    }

    public Criterion eqIfHasValue(String name, Object value) {
        return c().eqIfHasValue(name, value);
    }

    public static Criterion eqOrNull(String name, Object value) {
        return c().eqOrNull(name, value);
    }

    public static Criterion ne(String name, Object value) {
        return c().ne(name, value);
    }

    public static Criterion neIf(String name, Object value) {
        return c().neIf(name, value);
    }

    public static Criterion neOrNotNull(String name, Object value) {
        return c().neOrNotNull(name, value);
    }

    public static Criterion like(String name, String value) {
        return c().like(name, value);
    }

    public static Criterion likeIf(String name, String value) {
        return c().likeIf(name, value);
    }

    public static Criterion like(String name, String value, MatchMode matchMode) {
        return c().like(name, value, matchMode);
    }

    public static Criterion likeIf(String name, String value, MatchMode matchMode) {
        return c().likeIf(name, value, matchMode);
    }

    public static Criterion gt(String name, Object value) {
        return c().gt(name, value);
    }

    public static Criterion gtIf(String name, Object value) {
        return c().gtIf(name, value);
    }

    public static Criterion lt(String name, Object value) {
        return c().lt(name, value);
    }

    public static Criterion ltIf(String name, Object value) {
        return c().ltIf(name, value);
    }

    public static Criterion ge(String name, Object value) {
        return c().ge(name, value);
    }

    public static Criterion geIf(String name, Object value) {
        return c().geIf(name, value);
    }

    public static Criterion le(String name, Object value) {
        return c().le(name, value);
    }

    public static Criterion leIf(String name, Object value) {
        return c().leIf(name, value);
    }

    public static Criterion between(String name, Object lo, Object hi) {
        return c().between(name, lo, hi);
    }

    public Criterion in(String name, Object value) {
        return c().in(name, value);
    }

    public static Criterion in(String name, Object... values) {
        return c().in(name, values);
    }

    public static Criterion in(String name, Iterable values) {
        return c().in(name, values);
    }

    public static Criterion c() {
        return new CriterionImpl();
    }

    public static Builder q() {
        return new BuilderImpl();
    }

    public static Builder i() {
        return q().insert();
    }

    public static Builder u() {
        return q().update();
    }

    public static Builder d() {
        return q().delete();
    }

    public static Builder from(String type) {
        return q().from(type);
    }

    public static Builder from(String type, String alias) {
        return q().from(type, alias);
    }

    public static Builder from(Class type) {
        return q().from(type);
    }

    public static Builder from(Class type, String alias) {
        return q().from(type, alias);
    }

    public static Builder insert(String type) {
        return q().insert(type);
    }

    public static Builder update(String type) {
        return q().update(type);
    }

    public static Builder update(Class type) {
        return q().update(type);
    }

    public static Builder delete(String type) {
        return q().delete(type);
    }

    public static Builder delete(Class type) {
        return q().delete(type);
    }

    public static Builder sql() {
        return q().sql();
    }

    public static Builder sql(String type) {
        return sql().from(type);
    }

    public static Builder sql(String type, String alias) {
        return sql().from(type, alias);
    }

    public static Pair<String, Builder> sub(String fn, Builder subQuery) {
        return new Pair<String, Builder>(fn, subQuery);
    }

    private DSL() {
    }
}
