/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Builder.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data.dsl;

import cn.gtmap.egovplat.core.data.Order;
import cn.gtmap.egovplat.core.data.Pageable;

import java.util.Collection;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-7-2
 */
public interface Builder extends Criterion<Builder> {

    Builder sql();

    boolean isSql();

    Builder from(Class type);

    Builder from(Class type, String alias);

    Builder from(String type);

    Builder from(String... types);

    Builder from(Collection<String> types);

    Builder from(String type, String alias);

    Builder from(Builder subQuery);

    Builder from(Builder subQuery, String alias);

    Builder insert();

    Builder insert(String type);

    Builder update();

    Builder update(Class type);

    Builder update(String type);

    Builder delete();

    Builder delete(Class type);

    Builder delete(String type);

    Builder field(String name, Object value);

    Builder fields(Object... pairs);

    Builder fields(Map<String, Object> values);

    Builder select(String... fields);

    Builder select(Collection<String> fields);

    Builder select(Builder subQuery);

    Builder select(Builder subQuery, String alias);

    Builder distinct();

    Builder join(String path);

    Builder join(String path, String alias);

    Builder fetchJoin(String path);

    Builder fetchJoin(String path, String alias);

    Builder join(String path, JoinType type);

    Builder join(String path, String alias, JoinType type);

    Builder fetchJoin(String path, JoinType type);

    Builder fetchJoin(String path, String alias, JoinType type);

    Builder on(String onString);

    Builder on(String path1, String field1, String path2, String field2);

    Builder where(Criterion... criterions);

    Builder where(Collection<Criterion> criterions);

    Builder group(String... fields);

    Builder having(Criterion... criterions);

    Builder having(Collection<Criterion> criterions);

    Builder index(int index);

    Builder offset(int offset);

    Builder size(int size);

    Builder with(Pageable pageable);

    Builder desc(String field);

    Builder asc(String field);

    Builder order(boolean asc, String... fields);

    Builder order(Order... orders);

    Builder order(Collection<Order> orders);

    QueryParam build();
}
