package cn.gtmap.egovplat.core.bpm.model;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

/**
 * User: JIFF
 * Date: 2015/3/9
 */
public class ActivityModel  implements Serializable {
    String id;
    String name;

    boolean userTask;   //是否userTask

    List<String> userIds;   //候选人

    List<String> groupIds;  //候选角色

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public List<String> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public boolean isUserTask() {
        return userTask;
    }

    public void setUserTask(boolean userTask) {
        this.userTask = userTask;
    }

    public void addUser(String userId){
        if (userIds==null)
            userIds=new ArrayList();
        userIds.add(userId);
    }

    public void addGroup(String groupId){
        if (groupIds==null)
            groupIds=new ArrayList();
        groupIds.add(groupId);
    }

    public ActivityModel(){
        name="";
    }

    public ActivityModel(String id){
        this.id=id;
    }

    /**
     * 比较两个model是否一直
     * @param model
     * @return
     */
    public boolean hasDifference(ActivityModel model){
        if (model.getUserIds().size()==this.getUserIds().size()){
            for(String userId:this.userIds){
                if (!model.getUserIds().contains(userId)){
                    return true;
                }
            }
            return false;
        }
        return true;
    }


}
