/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AccessScope.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.core.bean;


import cn.gtmap.egovplat.core.util.EnumUtils;

import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-7-1
 */
public enum AccessScope implements Titleable, Dictable {

    ALL("所有人"),
    USER("登录用户"),
    ROLE("角色"),
    TOKEN("token认证"),
    SELF("仅自己可访问"),
    SESSION("需要会话授权"),
    PRIVILEGE("需要授权");

    private String title;

    AccessScope(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public boolean isPublic() {
        return this == ALL;
    }

    @Override
    public Map<String, String> getItems() {
        return EnumUtils.getDictMap(AccessScope.class);
    }
}
