/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AttrableJSONObject.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-31
 */
public class JSONAttrable extends AbstractAttrable implements Cloneable, Serializable {
    private static final long serialVersionUID = -2215595339918305246L;
    private JSONObject json;

    public JSONAttrable(JSONObject json) {
        this.json = json;
    }

    public JSONAttrable(Map<String, Object> map) {
        this.json = new JSONObject(map);
    }

    @SuppressWarnings("unchecked")
    public JSONAttrable(Properties properties) {
        this.json = new JSONObject((Map) properties);
    }

    public JSONAttrable() {
        json = new JSONObject();
    }

    public JSONObject getJson() {
        return json;
    }

    public void setJson(JSONObject json) {
        this.json = json;
    }

    @Override
    @JSONField(serialize = false)
    public boolean isAttrsEmpty() {
        return json.isEmpty();
    }

    @Override
    public boolean hasAttr(String key) {
        return json.containsKey(key);
    }

    @Override
    public String getAttr(String key) {
        return json.getString(key);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        return convert(json.get(key), targetType);
    }

    @Override
    @JSONField(serialize = false)
    public Collection<String> getAttrKeys() {
        return json.keySet();
    }

    @Override
    public void setAttr(String key, Object value) {
        json.put(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        json.putAll(map);
    }

    @Override
    public void removeAttr(String key) {
        json.remove(key);
    }

    @Override
    public void clearAttrs() {
        json.clear();
    }

    @Override
    public JSONAttrable clone() {
        JSONAttrable obj = null;
        try {
            obj = (JSONAttrable) super.clone();
            obj.setJson((JSONObject) json.clone());
        } catch (CloneNotSupportedException ignored) {
        }
        return obj;
    }

    @Override
    public int hashCode() {
        return json.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JSONAttrable && ((JSONAttrable) obj).getJson().equals(json);
    }

    @Override
    public String toString() {
        return json.toJSONString();
    }

    public static <T> T convert(Object value, Class<T> targetType) {
        return FastjsonConverter.INSTANCE.convert(value, targetType);
    }
}
