/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     FastjsonConverter.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.core.attr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.TypeUtils;
import cn.gtmap.egovplat.core.bean.Converter;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-11-6
 */
public class FastjsonConverter implements Converter {
    public static Converter INSTANCE = new FastjsonConverter();

    @Override
    @SuppressWarnings("unchecked")
    public <T> T convert(Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        Class valueClass = value.getClass();
        if (targetType == valueClass || targetType == Object.class || targetType.isAssignableFrom(valueClass)) {
            return (T) value;
        }
        if (targetType == String.class) {
            return (T) JSON.toJSONString(value);
        }
        if (value instanceof String) {
            return JSON.parseObject((String) value, targetType);
        } else {
            return TypeUtils.castToJavaBean(JSON.toJSON(value), targetType);
        }
    }
}
