/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     CompositeAttrableJSONObject.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.bean.Attrable;
import com.google.common.collect.Sets;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-31
 */
public class CompositeAttrable extends AbstractAttrable implements Serializable {
    private static final long serialVersionUID = 7077593803642902540L;
    private final Attrable attr;
    private final Attrable parent;

    public CompositeAttrable(Attrable attr, Attrable parent) {
        this.attr = attr;
        this.parent = parent;
    }

    public Attrable getAttr() {
        return attr;
    }

    @Override
    public boolean isAttrsEmpty() {
        return attr.isAttrsEmpty() && parent.isAttrsEmpty();
    }

    @Override
    public boolean hasAttr(String key) {
        return attr.hasAttr(key) || parent.hasAttr(key);
    }

    @Override
    public String getAttr(String key) {
        return attr.hasAttr(key) ? attr.getAttr(key) : parent.getAttr(key);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        return attr.hasAttr(key) ? attr.getAttr(key, targetType) : parent.getAttr(key, targetType);
    }

    @Override
    public Collection<String> getAttrKeys() {
        Set<String> keys = Sets.newLinkedHashSet(attr.getAttrKeys());
        keys.addAll(parent.getAttrKeys());
        return keys;
    }

    @Override
    public void setAttr(String key, Object value) {
        attr.setAttr(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        attr.setAttrs(map);
    }

    @Override
    public void removeAttr(String key) {
        attr.removeAttr(key);
    }

    @Override
    public String toString() {
        return attr.toString();
    }
}
