/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Attrs.java
 * Modifier: yangxin
 * Modified: 2014-06-12 20:59
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.bean.Attrable;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-12
 */
public final class Attrs {

    public static final Attrable EMPTY_ATTRABLE = new AbstractAttrable() {
        @Override
        public <T> T getAttr(String key, Class<T> targetType) {
            return null;
        }

        @Override
        public Collection<String> getAttrKeys() {
            return Collections.emptyList();
        }

        @Override
        public void setAttr(String key, Object value) {
        }

        @Override
        public void removeAttr(String key) {
        }
    };

    public static Attrable newJSONAttrable() {
        return new JSONAttrable();
    }

    public static Attrable newJSONAttrable(JSONObject json) {
        return new JSONAttrable(json);
    }

    public static Attrable newJSONAttrable(Map<String, Object> map) {
        return new JSONAttrable(map);
    }

    public static Attrable newJSONAttrable(Properties properties) {
        return new JSONAttrable(properties);
    }

    public static Attrable newJSONAttrableWithSize(int size) {
        return new JSONAttrable(new JSONObject(size));
    }

    public static Attrable newMapAttrable() {
        return new MapAttrable();
    }

    public static Attrable newMapAttrable(Map<String, String> map) {
        return new MapAttrable(map);
    }

    public static Attrable newMapAttrable(Properties properties) {
        return new MapAttrable(properties);
    }

    public static Attrable newMapAttrableWithSize(int size) {
        return new MapAttrable(new LinkedHashMap<String, String>(size));
    }

    public static Attrable compositeAttrable(Attrable attrable, Attrable parent) {
        return new CompositeAttrable(attrable, parent);
    }

    public static Attrable compositeAttrable(Attrable attr, Attrable... parents) {
        return new CompositeAttrableEx(attr, parents);
    }

    public static Attrable compositeAttrable(Attrable attr, Collection<Attrable> parents) {
        return new CompositeAttrableEx(attr, parents);
    }

    public static Attrable compositeAttrable(Properties props, Properties parent) {
        return compositeAttrable(newJSONAttrable(props), newJSONAttrable(parent));
    }

    private Attrs() {
    }
}
