/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Field.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:23
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.annotation;

import cn.gtmap.egovplat.core.model.FieldType;
import cn.gtmap.egovplat.core.model.Views;

import java.lang.annotation.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Field {
    /**
     * 名称
     */
    String value() default "";

    /**
     * 占位描述
     */
    String placeholder() default "";

    /**
     * 说明
     */
    String desc() default "";

    /**
     * 数据类型
     */
    FieldType type() default FieldType.TEXT;

    /**
     * 数据字典
     */
    String dict() default "";

    /**
     * 展示类型
     */
    String view() default Views.TEXT;

    /**
     * 最大长度
     */
    int length() default 0;

    /**
     * 是否可为空
     */
    boolean nullable() default true;

    /**
     * 校验正则表达式
     */
    String validation() default "";

    /**
     * 默认值
     */
    String def() default "";

    /**
     * 展示格式
     */
    String format() default "";
}
